/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.instances.Formatting;
import com.vmware.vipclient.i18n.base.instances.LocaleMessage;
import com.vmware.vipclient.i18n.base.instances.Message;
import com.vmware.vipclient.i18n.base.instances.TranslationMessage;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nFactory {
    Logger logger = LoggerFactory.getLogger(I18nFactory.class);
    private VIPCfg cfg;
    private static I18nFactory factory = null;
    private Map<String, Message> messages = new HashMap<String, Message>();
    private Map<String, Formatting> formattings = new HashMap<String, Formatting>();

    private I18nFactory(VIPCfg cfg) {
        this.cfg = cfg;
    }

    public static synchronized I18nFactory getInstance(VIPCfg cfg) {
        if (factory == null) {
            factory = new I18nFactory(cfg);
        }
        factory.setCfg(cfg);
        return factory;
    }

    public static I18nFactory getInstance() {
        return factory;
    }

    public Message getMessageInstance(Class c, VIPCfg cfg) {
        Message i = null;
        if (c == null) {
            return i;
        }
        if (this.getCfg().getProductName() == null || this.getCfg().getVersion() == null) {
            this.logger.error("ProductName|Version is null!");
            return i;
        }
        if (this.getCfg().getVipServer() == null && this.getCfg().getOfflineResourcesBaseUrl() == null) {
            this.logger.error("One of offlineResourcesBaseUrl and vipServer must not be null!");
            return i;
        }
        String key = null == cfg ? c.getCanonicalName() : c.getCanonicalName() + "." + cfg.getProductName();
        if (this.messages.containsKey(key)) {
            return this.messages.get(key);
        }
        try {
            Object o = c.newInstance();
            if (o instanceof Message) {
                i = (Message)o;
                this.messages.put(key, i);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.error(e.getMessage());
        }
        if (i instanceof TranslationMessage) {
            ((TranslationMessage)i).setCfg(cfg);
        }
        if (i instanceof LocaleMessage) {
            ((LocaleMessage)i).setCfg(cfg);
        }
        return i;
    }

    public Message getMessageInstance(Class c) {
        return this.getMessageInstance(c, null);
    }

    public Formatting getFormattingInstance(Class c) {
        Formatting i = null;
        if (c == null) {
            this.logger.error("the parameter class is null!");
            return i;
        }
        if (this.getCfg().getI18nScope() == null) {
            this.logger.error("i18nScope is null!");
            return i;
        }
        String key = c.getCanonicalName();
        if (this.formattings.containsKey(key)) {
            return this.formattings.get(key);
        }
        try {
            Object o = c.newInstance();
            if (o instanceof Formatting) {
                i = (Formatting)o;
                this.formattings.put(key, i);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.error(e.getMessage());
        }
        return i;
    }

    public Map<String, Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Map<String, Message> messages) {
        this.messages = messages;
    }

    public Map<String, Formatting> getFormattings() {
        return this.formattings;
    }

    public void setFormattings(Map<String, Formatting> formattings) {
        this.formattings = formattings;
    }

    public VIPCfg getCfg() {
        return this.cfg;
    }

    public void setCfg(VIPCfg cfg) {
        this.cfg = cfg;
    }
}

