/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.cache;

import com.vmware.vipclient.i18n.base.cache.Cache;
import com.vmware.vipclient.i18n.base.cache.CacheItem;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MessageCache
implements Cache {
    private String id = "cache-default";
    private long expiredTime = 864000000L;
    private long lastClean = System.currentTimeMillis();
    private final Map<String, MessageCacheItem> cachedComponentsMap = new LinkedHashMap<String, MessageCacheItem>();
    private Map<String, Integer> hitMap = new LinkedHashMap<String, Integer>();
    private int capacityByKey = -1;
    private int capacityX = -1;
    private String dropId;

    public Map<String, MessageCacheItem> getCachedTranslationMap() {
        return this.cachedComponentsMap;
    }

    public Map<String, Integer> getHitMap() {
        return this.hitMap;
    }

    public MessageCache() {
    }

    public MessageCache(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public CacheItem get(String cacheKey) {
        Integer i = this.hitMap.get(cacheKey);
        if (i != null) {
            this.hitMap.put(cacheKey, i + 1);
        }
        return this.cachedComponentsMap.get(cacheKey);
    }

    public String getRemovedKeyFromHitMap() {
        Set<String> tt;
        String key = "";
        Set<String> s = this.hitMap.keySet();
        if (s.size() == 0 && (tt = this.cachedComponentsMap.keySet()).size() > 0) {
            key = tt.iterator().next();
            return key;
        }
        int t = 0;
        for (String k : s) {
            int i = this.hitMap.get(k);
            if (t != 0 && i >= t) continue;
            t = i;
            key = k;
        }
        return key;
    }

    @Override
    public synchronized boolean put(String cacheKey, CacheItem itemToCache) {
        if (itemToCache != null) {
            if (this.isFull()) {
                String k = this.getRemovedKeyFromHitMap();
                this.remove(k);
                this.hitMap.remove(k);
            }
            if (!this.isFull()) {
                MessageCacheItem cacheItem = this.cachedComponentsMap.get(cacheKey);
                if (cacheItem == null) {
                    this.cachedComponentsMap.put(cacheKey, (MessageCacheItem)itemToCache);
                } else {
                    cacheItem.setCacheItem((MessageCacheItem)itemToCache);
                }
            }
        }
        return this.cachedComponentsMap.containsKey(cacheKey);
    }

    @Override
    public synchronized boolean remove(String cacheKey) {
        MessageCacheItem o1 = this.cachedComponentsMap.get(cacheKey);
        Integer o2 = this.hitMap.get(cacheKey);
        this.cachedComponentsMap.remove(cacheKey);
        this.hitMap.remove(cacheKey);
        if (o1 != null) {
            o1 = null;
        }
        if (o2 != null) {
            o2 = null;
        }
        return !this.cachedComponentsMap.containsKey(cacheKey);
    }

    @Override
    public synchronized boolean clear() {
        Set<String> s = this.cachedComponentsMap.keySet();
        for (String key : s) {
            MessageCacheItem o = this.cachedComponentsMap.get(key);
            if (o == null) continue;
            o = null;
        }
        this.cachedComponentsMap.clear();
        Set<String> s2 = this.hitMap.keySet();
        for (String key : s2) {
            Integer o = this.hitMap.get(key);
            if (o == null) continue;
            o = null;
        }
        this.hitMap.clear();
        return this.cachedComponentsMap.isEmpty();
    }

    @Override
    public int size() {
        return this.cachedComponentsMap.size();
    }

    @Override
    public Set<String> keySet() {
        return this.cachedComponentsMap.keySet();
    }

    @Override
    public synchronized long getExpiredTime() {
        return this.expiredTime;
    }

    @Override
    public synchronized void setExpiredTime(long millis) {
        this.expiredTime = millis;
    }

    @Override
    public synchronized long getLastClean() {
        return this.lastClean;
    }

    @Override
    public synchronized void setLastClean(long millis) {
        this.lastClean = millis;
    }

    public int getCachedKeySize() {
        Set<String> s = this.getCachedTranslationMap().keySet();
        int size = 0;
        for (String key : s) {
            MessageCacheItem cacheItem = this.getCachedTranslationMap().get(key);
            if (cacheItem == null) continue;
            size += cacheItem.getCachedData().size();
        }
        return size;
    }

    public void setCapacityByKey(int capacityByKey) {
        this.capacityByKey = capacityByKey;
    }

    public int getCapacityByKey() {
        return this.capacityByKey;
    }

    @Override
    public void setXCapacity(int capacityX) {
        this.capacityX = capacityX;
    }

    @Override
    public int getXCapacity() {
        return this.capacityX;
    }

    public boolean isFull() {
        int keysize;
        boolean f = false;
        if (this.getXCapacity() >= 0 && this.capacityX <= this.size()) {
            f = true;
        }
        if ((keysize = this.getCapacityByKey()) >= 0 && keysize <= this.getCachedKeySize()) {
            f = true;
        }
        return f;
    }

    @Override
    @Deprecated
    public boolean isExpired() {
        boolean f = false;
        long expired = this.getExpiredTime();
        long lastClean = this.getLastClean();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastClean > expired) {
            f = true;
        }
        return f;
    }

    @Override
    public String getDropId() {
        return this.dropId;
    }

    public void setDropId(String dropId) {
        this.dropId = dropId;
    }
}

