/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.messages.api.opt.LocaleOpt;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import com.vmware.vipclient.i18n.messages.dto.LocaleDTO;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLocaleOpt
implements LocaleOpt {
    private Logger logger = LoggerFactory.getLogger((String)RemoteLocaleOpt.class.getName());
    private LocaleDTO dto = null;

    public RemoteLocaleOpt(LocaleDTO dto) {
        this.dto = dto;
    }

    @Override
    public Map<String, String> getRegions(String locale) {
        this.logger.debug("Look for regions from Singleton Service for locale [{}]!", (Object)locale);
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getRegionListURL(locale, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "GET", null);
        String responseData = (String)response.get("body");
        if (responseData == null || responseData.isEmpty()) {
            return null;
        }
        Map respMap = null;
        try {
            JSONObject jsonObject = (JSONObject)JSONValue.parseWithException((String)responseData);
            JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"data");
            if (jsonArray != null && !jsonArray.isEmpty()) {
                Map<String, Object> regionMap = JSONUtils.getMapFromJson(jsonArray.get(0).toString());
                respMap = (Map)regionMap.get("territories");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return respMap;
    }

    @Override
    public Map<String, String> getSupportedLanguages(String locale) {
        this.logger.debug("Look for supported languages from Singleton Service for product [{}], version [{}], locale [{}]!", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getSupportedLanguageListURL(VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL(), this.dto, locale), "GET", null);
        String responseData = (String)response.get("body");
        if (responseData == null || responseData.isEmpty()) {
            return null;
        }
        HashMap<String, String> dispMap = null;
        try {
            JSONObject jsonObject = (JSONObject)JSONValue.parseWithException((String)responseData);
            Object data = jsonObject.get((Object)"data");
            if (data == null || "".equals(data)) {
                return dispMap;
            }
            JSONObject jsonData = (JSONObject)data;
            JSONArray jsonArray = (JSONArray)jsonData.get((Object)"languages");
            if (jsonArray != null && !jsonArray.isEmpty()) {
                dispMap = new HashMap<String, String>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Map<String, Object> tmpMap = JSONUtils.getMapFromJson(jsonArray.get(i).toString());
                    dispMap.put(tmpMap.get("languageTag").toString(), tmpMap.get("displayName").toString());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return dispMap;
    }
}

