/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.BaseOpt;
import com.vmware.vipclient.i18n.messages.api.opt.MessageOpt;
import com.vmware.vipclient.i18n.messages.api.opt.Opt;
import com.vmware.vipclient.i18n.messages.api.url.URLUtils;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentBasedOpt
extends BaseOpt
implements Opt,
MessageOpt {
    private final Logger logger = LoggerFactory.getLogger((String)ComponentBasedOpt.class.getName());
    private MessagesDTO dto = null;

    public ComponentBasedOpt(MessagesDTO dto) {
        this.dto = dto;
    }

    @Override
    public void getComponentMessages(MessageCacheItem cacheItem) {
        Map<String, Object> response;
        Integer responseCode;
        String url = V2URL.getComponentTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL());
        HashMap<String, String> headers = new HashMap<String, String>();
        if (cacheItem.getEtag() != null) {
            headers.put("If-None-Match", cacheItem.getEtag());
        }
        if ((responseCode = (Integer)(response = VIPCfg.getInstance().getVipService().getHttpRequester().request(url, "GET", null, headers)).get("response_code")) != null && (responseCode.equals(200) || responseCode.equals(304))) {
            Long maxAgeMillis;
            long timestamp = response.get("response_timestamp") == null ? System.currentTimeMillis() : (Long)response.get("response_timestamp");
            String etag = URLUtils.createEtagString((Map)response.get("headers"));
            Long l = maxAgeMillis = response.get("max-age") == null ? null : (Long)response.get("max-age");
            if (responseCode.equals(200)) {
                JSONObject respObj = (JSONObject)JSONValue.parse((String)((String)response.get("body")));
                try {
                    JSONObject messages;
                    if (this.getResponseCode(respObj) == 200 && (messages = this.getMsgsJson(response)) != null) {
                        cacheItem.setCacheItem((Map<String, String>)messages, etag, timestamp, maxAgeMillis);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to get messages");
                }
            } else {
                cacheItem.setCacheItem(etag, timestamp, maxAgeMillis);
            }
        }
    }

    private JSONObject getMsgsJson(Map<String, Object> response) {
        if (response != null && response.get("response_code") != null && response.get("response_code").equals(200)) {
            String responseStr = (String)response.remove("body");
            if (null == responseStr || responseStr.equals("")) {
                return null;
            }
            JSONObject msgObject = (JSONObject)this.getMessagesFromResponse(responseStr, "messages");
            return msgObject;
        }
        return null;
    }

    public String postString() {
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getKeyTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "POST", this.dto.getSource());
        String responseStr = (String)response.get("body");
        Object o = this.getMessagesFromResponse(responseStr, "translation");
        if (o != null) {
            return (String)o;
        }
        Object m = this.getStatusFromResponse(responseStr, "message");
        if (m != null) {
            this.logger.warn((String)m);
        }
        return "";
    }

    public String postSourceSet(String sourceSet) {
        String status = "";
        if (sourceSet == null || "".equalsIgnoreCase(sourceSet)) {
            return status;
        }
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getPostKeys(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "POST", sourceSet);
        String responseStr = (String)response.get("body");
        Object o = this.getStatusFromResponse(responseStr, "code");
        if (o != null) {
            status = o.toString();
        }
        return status;
    }

    public String getTranslationStatus() {
        String status = "";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkTranslationStatus", "true");
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getComponentTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "GET", params);
        String responseStr = (String)response.get("body");
        if (null == responseStr || responseStr.equals("")) {
            return status;
        }
        Object o = this.getStatusFromResponse(responseStr, "code");
        if (o != null) {
            status = o.toString();
        }
        return status;
    }
}

