/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.cache;

import com.vmware.vipclient.i18n.VIPCfg;

public abstract class CacheItem {
    private String etag;
    private long timestamp;
    private Long maxAgeMillis = 86400000L;

    public String getEtag() {
        return this.etag;
    }

    protected void setEtag(String etag) {
        this.etag = etag;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    protected void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getMaxAgeMillis() {
        return this.maxAgeMillis;
    }

    protected void setMaxAgeMillis(Long maxAgeMillis) {
        if (maxAgeMillis != null) {
            this.maxAgeMillis = maxAgeMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        if (VIPCfg.getInstance().getVipServer() == null) {
            return false;
        }
        if (VIPCfg.getInstance().getCacheExpiredTime() != 0L) {
            return false;
        }
        CacheItem cacheItem = this;
        synchronized (cacheItem) {
            return System.currentTimeMillis() - this.getTimestamp() >= this.maxAgeMillis;
        }
    }
}

