/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.cache;

import com.vmware.vipclient.i18n.base.cache.CacheItem;
import java.util.HashMap;
import java.util.Map;

public class MessageCacheItem
extends CacheItem {
    private final Map<String, String> cachedData = new HashMap<String, String>();

    public MessageCacheItem() {
    }

    public MessageCacheItem(Map<String, String> dataMap) {
        if (dataMap != null) {
            this.cachedData.putAll(dataMap);
        }
    }

    public MessageCacheItem(Map<String, String> dataMap, String etag, long timestamp, Long maxAgeMillis) {
        this.setCacheItem(dataMap, etag, timestamp, maxAgeMillis);
    }

    public synchronized void setCacheItem(Map<String, String> dataToCache, String etag, long timestamp, Long maxAgeMillis) {
        if (dataToCache != null) {
            this.cachedData.putAll(dataToCache);
        }
        this.setCacheItem(etag, timestamp, maxAgeMillis);
    }

    public synchronized void setCacheItem(String etag, long timestamp, Long maxAgeMillis) {
        if (etag != null && !etag.isEmpty()) {
            this.setEtag(etag);
        }
        this.setTimestamp(timestamp);
        if (maxAgeMillis != null) {
            this.setMaxAgeMillis(maxAgeMillis);
        }
    }

    public synchronized void setCacheItem(MessageCacheItem cacheItem) {
        this.setCacheItem(cacheItem.getCachedData(), cacheItem.getEtag(), cacheItem.getTimestamp(), cacheItem.getMaxAgeMillis());
    }

    public Map<String, String> getCachedData() {
        return this.cachedData;
    }
}

