/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.instances;

import com.vmware.vipclient.i18n.I18nFactory;
import com.vmware.vipclient.i18n.base.instances.Formatting;
import com.vmware.vipclient.i18n.base.instances.PatternMessage;
import com.vmware.vipclient.i18n.l2.common.PatternCategory;
import com.vmware.vipclient.i18n.l2.text.DateFormat;
import java.util.Locale;
import org.json.JSONObject;

public class DateFormatting
implements Formatting {
    public String formatDate(Object obj, String pattern, Locale locale) {
        return this.formatDate(obj, pattern, null, locale);
    }

    public String formatDate(Object obj, String pattern, String timeZone, Locale locale) {
        if (null == obj || "".equalsIgnoreCase(obj.toString())) {
            return null;
        }
        if (null == pattern || "".equalsIgnoreCase(pattern)) {
            pattern = "medium";
        }
        if (null == timeZone) {
            timeZone = "";
        }
        JSONObject dateFormatData = null;
        I18nFactory factory = I18nFactory.getInstance();
        if (factory == null) {
            throw new RuntimeException("I18nFactory is null, please create it first!");
        }
        PatternMessage p = (PatternMessage)factory.getMessageInstance(PatternMessage.class);
        JSONObject localeFormatData = p.getPatternMessage(locale);
        if (localeFormatData != null) {
            dateFormatData = (JSONObject)localeFormatData.get(PatternCategory.DATES.toString());
        }
        if (dateFormatData == null) {
            throw new RuntimeException("Can't format " + obj + " without pattern data!");
        }
        DateFormat dateFormat = DateFormat.getInstance(dateFormatData, pattern, locale.toLanguageTag());
        return dateFormat.format(obj, timeZone);
    }

    public String formatDate(Object obj, String pattern, String timeZone, String language, String region) {
        if (null == obj || "".equalsIgnoreCase(obj.toString())) {
            return null;
        }
        if (null == pattern) {
            pattern = "medium";
        }
        if (null == timeZone) {
            timeZone = "";
        }
        JSONObject dateFormatData = null;
        I18nFactory factory = I18nFactory.getInstance();
        if (factory == null) {
            throw new RuntimeException("I18nFactory is null, please create it first!");
        }
        PatternMessage p = (PatternMessage)factory.getMessageInstance(PatternMessage.class);
        JSONObject localeFormatData = p.getPatternMessage(language, region);
        if (localeFormatData != null) {
            dateFormatData = (JSONObject)localeFormatData.get(PatternCategory.DATES.toString());
        }
        if (dateFormatData == null) {
            throw new RuntimeException("Can't format " + obj + " without pattern data!");
        }
        DateFormat dateFormat = DateFormat.getInstance(dateFormatData, pattern, language, region);
        return dateFormat.format(obj, timeZone);
    }
}

