/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.local;

import com.vmware.i18n.PatternUtil;
import com.vmware.i18n.dto.LocaleDataDTO;
import com.vmware.i18n.pattern.service.impl.PatternServiceImpl;
import com.vmware.i18n.utils.CommonUtil;
import com.vmware.vipclient.i18n.base.cache.PatternCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.PatternOpt;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPatternOpt
implements PatternOpt {
    Logger logger = LoggerFactory.getLogger(LocalPatternOpt.class);

    @Override
    public void getPatterns(String locale, PatternCacheItem cacheItem) {
        this.logger.debug("Look for pattern from local bundle for locale [{}]!", (Object)locale);
        String normalizedLocale = CommonUtil.getCLDRLocale((String)locale, (Map)PatternServiceImpl.localePathMap, (Map)PatternServiceImpl.localeAliasesMap);
        this.logger.debug("Normalized locale for locale [{}] is [{}]", (Object)locale, (Object)normalizedLocale);
        this.getPatternsByLocale(normalizedLocale, cacheItem);
    }

    @Override
    public void getPatterns(String language, String region, PatternCacheItem cacheItem) {
        this.logger.debug("Look for pattern from local bundle for language [{}], region [{}]!", (Object)language, (Object)region);
        LocaleDataDTO resultData = CommonUtil.getLocale((String)language, (String)region);
        String normalizedLocale = resultData.getLocale();
        this.logger.debug("Normalized locale for language [{}], region [{}] is [{}]", new Object[]{language, region, normalizedLocale});
        this.getPatternsByLocale(normalizedLocale, cacheItem);
    }

    private void getPatternsByLocale(String normalizedLocale, PatternCacheItem cacheItem) {
        if (normalizedLocale == null || normalizedLocale.isEmpty()) {
            return;
        }
        try {
            String patternStr = PatternUtil.getPatternFromLib((String)normalizedLocale, null);
            JSONObject jsonObject = new JSONObject(patternStr);
            Map patterns = jsonObject.toMap();
            if (patterns != null && patterns.get("categories") != null) {
                this.logger.debug("Found the pattern from local bundle for locale [{}].\n", (Object)normalizedLocale);
                cacheItem.set((Map)patterns.get("categories"), System.currentTimeMillis());
            } else {
                this.logger.warn("Didn't find the pattern from local bundle for locale [{}].\n", (Object)normalizedLocale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
    }
}

