/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.url;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class URLUtils {
    public static final String BODY = "body";
    public static final String HEADERS = "headers";
    public static final String RESPONSE_CODE = "response_code";
    public static final String RESPONSE_MSG = "response_msg";
    public static final String RESPONSE_TIMESTAMP = "response_timestamp";
    public static final String IF_NONE_MATCH_HEADER = "If-None-Match";
    public static final String ETAG = "ETag";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String MAX_AGE_MILLIS = "max-age";

    private URLUtils() {
    }

    public static String appendParamToURL(StringBuilder u, String key, String value) {
        if (u.toString().indexOf(63) >= 0 && u.toString().indexOf(61) >= 0) {
            if ("".equalsIgnoreCase(key)) {
                u.append("&").append(value);
            } else {
                u.append("&").append(key).append("=").append(value);
            }
        } else if ("".equalsIgnoreCase(key)) {
            u.append("?").append(value);
        } else {
            u.append("?").append(key).append("=").append(value);
        }
        return u.toString();
    }

    public static boolean isStringInListIgnoreCase(List<String> list, String targetStr) {
        for (String str : list) {
            if (null == str || !str.equalsIgnoreCase(targetStr)) continue;
            return true;
        }
        return false;
    }

    public static String createEtagString(Map<String, List<String>> responseHeaders) {
        if (responseHeaders != null) {
            List<String> etags = responseHeaders.get(ETAG);
            return URLUtils.createIfNoneMatchValue(etags);
        }
        return null;
    }

    public static Long getMaxAgeMillis(Map<String, List<String>> responseHeaders) {
        List<String> cacheCtrlString;
        Long maxAge = null;
        if (responseHeaders != null && (cacheCtrlString = responseHeaders.get(CACHE_CONTROL)) != null && !cacheCtrlString.isEmpty()) {
            for (String ccs : cacheCtrlString) {
                String[] cacheCtrlDirectives;
                for (String ccd : cacheCtrlDirectives = ccs.split(",")) {
                    String[] ccdString = ccd.split("=");
                    if (!ccdString[0].equals(MAX_AGE_MILLIS)) continue;
                    return Long.parseLong(ccdString[1]) * 1000L;
                }
            }
        }
        return maxAge;
    }

    private static String createIfNoneMatchValue(List<String> etags) {
        if (etags == null || etags.isEmpty()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        Iterator<String> it = etags.iterator();
        b.append(it.next());
        while (it.hasNext()) {
            b.append(", ").append(it.next());
        }
        return b.toString();
    }
}

