/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.server.ComponentBasedOpt;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.BaseService;
import com.vmware.vipclient.i18n.messages.service.CacheService;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.JSONUtils;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentService
extends BaseService {
    private MessagesDTO dto = null;
    Logger logger = LoggerFactory.getLogger(ComponentService.class);

    public ComponentService(MessagesDTO dto) {
        this.dto = dto;
    }

    private void refreshCacheItem(MessageCacheItem cacheItem, Iterator<DataSourceEnum> msgSourceQueueIter) {
        if (!msgSourceQueueIter.hasNext()) {
            this.logger.debug(FormatUtils.format("Failed to get messages for component {0}, locale: {1} from any available data source", this.dto.getComponent(), this.dto.getLocale()));
            return;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        if (!this.proceed(this.dto, dataSource)) {
            this.refreshCacheItem(cacheItem, msgSourceQueueIter);
        } else {
            long timestampOld = cacheItem.getTimestamp();
            String localeOrig = this.dto.getLocale();
            if (dataSource.equals((Object)DataSourceEnum.VIP) && this.dto.getLocale().equals("source")) {
                this.dto.setLocale("latest");
            }
            dataSource.createMessageOpt(this.dto).getComponentMessages(cacheItem);
            long timestamp = cacheItem.getTimestamp();
            if (timestampOld == timestamp) {
                this.logger.debug(FormatUtils.format("Failed to get messages for component {0}, locale: {1}, data source: {2}.", this.dto.getComponent(), this.dto.getLocale(), dataSource.toString()));
            }
            this.dto.setLocale(localeOrig);
            if (timestamp == 0L) {
                this.refreshCacheItem(cacheItem, msgSourceQueueIter);
            }
        }
    }

    public MessageCacheItem getMessages() {
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        return this.getMessages(fallbackLocalesIter);
    }

    public MessageCacheItem getMessages(Iterator<Locale> fallbackLocalesIter) {
        return new MessageCacheItem(this.getMessageCacheItem(fallbackLocalesIter).getMessages());
    }

    public TranslationsDTO getTranslations() {
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        return this.getTranslations(fallbackLocalesIter);
    }

    public TranslationsDTO getTranslations(Iterator<Locale> fallbackLocalesIter) {
        return this.getMessageCacheItem(fallbackLocalesIter);
    }

    private TranslationsDTO getMessageCacheItem(Iterator<Locale> fallbackLocalesIter) {
        this.doLocaleMatching(this.dto);
        CacheService cacheService = new CacheService(this.dto);
        MessageCacheItem cacheItem = cacheService.getCacheOfComponent();
        if (cacheItem != null) {
            if (cacheItem.isExpired()) {
                this.refreshCacheItemTask(cacheItem);
            }
        } else {
            cacheItem = this.createCacheItem();
            if (cacheItem.getCachedData().isEmpty()) {
                return this.getFallbackLocaleMessages(fallbackLocalesIter);
            }
        }
        return new TranslationsDTO(this.dto.getLocale(), cacheItem);
    }

    private TranslationsDTO getFallbackLocaleMessages(Iterator<Locale> fallbackLocalesIter) {
        if (fallbackLocalesIter != null && fallbackLocalesIter.hasNext()) {
            Locale fallbackLocale = fallbackLocalesIter.next();
            if (fallbackLocale.toLanguageTag().equals(this.dto.getLocale())) {
                return this.getFallbackLocaleMessages(fallbackLocalesIter);
            }
            MessagesDTO fallbackLocaleDTO = new MessagesDTO(this.dto.getComponent(), fallbackLocale.toLanguageTag(), this.dto.getProductID(), this.dto.getVersion());
            return new ComponentService(fallbackLocaleDTO).getMessageCacheItem(fallbackLocalesIter);
        }
        return new TranslationsDTO(this.dto.getLocale(), new MessageCacheItem());
    }

    private MessageCacheItem createCacheItem() {
        CacheService cacheService = new CacheService(this.dto);
        MessageCacheItem cacheItem = new MessageCacheItem();
        this.refreshCacheItem(cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().iterator());
        if (!cacheItem.getCachedData().isEmpty()) {
            cacheService.addCacheOfComponent(cacheItem);
        }
        return cacheItem;
    }

    private void refreshCacheItemTask(MessageCacheItem cacheItem) {
        Runnable runnable = () -> {
            try {
                this.refreshCacheItem(cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        new Thread(runnable).start();
    }

    public boolean isComponentAvailable() {
        boolean r = false;
        Long s = null;
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            ComponentBasedOpt dao = new ComponentBasedOpt(this.dto);
            String json = dao.getTranslationStatus();
            if (!JSONUtils.isEmpty(json)) {
                try {
                    s = Long.parseLong(json);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
            }
            r = s != null && s == 206L;
        }
        return r;
    }

    public static class TranslationsDTO {
        String locale;
        Map<String, String> messages;

        TranslationsDTO(String locale, MessageCacheItem messageCacheItem) {
            this.locale = locale;
            this.messages = new HashMap<String, String>();
            this.messages.putAll(messageCacheItem.getCachedData());
        }

        public String getLocale() {
            return this.locale;
        }

        public Map<String, String> getMessages() {
            return this.messages;
        }
    }
}

