/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.base.cache.Cache;
import com.vmware.vipclient.i18n.base.cache.FormatCacheItem;
import com.vmware.vipclient.i18n.base.cache.LocaleCacheItem;
import com.vmware.vipclient.i18n.base.cache.PatternCacheItem;
import com.vmware.vipclient.i18n.base.cache.TranslationCacheManager;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;

public class FormattingCacheService {
    public void addPatterns(String locale, PatternCacheItem o) {
        String cacheKey = this.getPatternsCacheKey(locale);
        this.addFormattings(cacheKey, o);
    }

    public void addPatterns(String language, String region, PatternCacheItem o) {
        String cacheKey = this.getPatternsCacheKey(language, region);
        this.addFormattings(cacheKey, o);
    }

    public void addSupportedLanguages(BaseDTO dto, String locale, LocaleCacheItem o) {
        String cacheKey = this.getSupportedLanguagesCacheKey(dto, locale);
        this.addFormattings(cacheKey, o);
    }

    public void addRegions(String locale, LocaleCacheItem o) {
        String cacheKey = this.getRegionsCacheKey(locale);
        this.addFormattings(cacheKey, o);
    }

    public PatternCacheItem getPatterns(String locale) {
        String cacheKey = this.getPatternsCacheKey(locale);
        return (PatternCacheItem)this.getFormattings(cacheKey);
    }

    public PatternCacheItem getPatterns(String language, String region) {
        String cacheKey = this.getPatternsCacheKey(language, region);
        return (PatternCacheItem)this.getFormattings(cacheKey);
    }

    public LocaleCacheItem getSupportedLanguages(BaseDTO dto, String locale) {
        String cacheKey = this.getSupportedLanguagesCacheKey(dto, locale);
        return (LocaleCacheItem)this.getFormattings(cacheKey);
    }

    public LocaleCacheItem getRegions(String locale) {
        String cacheKey = this.getRegionsCacheKey(locale);
        return (LocaleCacheItem)this.getFormattings(cacheKey);
    }

    private String getPatternsCacheKey(String locale) {
        return "patterns_" + locale;
    }

    private String getPatternsCacheKey(String language, String region) {
        return "patterns_" + language + "-" + region;
    }

    private String getSupportedLanguagesCacheKey(BaseDTO dto, String locale) {
        return "dispns_" + dto.getProductID() + "_" + dto.getVersion() + "_" + locale;
    }

    private String getRegionsCacheKey(String locale) {
        return "regions_" + locale;
    }

    private void addFormattings(String key, FormatCacheItem o) {
        if (null != key && null != o) {
            TranslationCacheManager.getInstance();
            Cache c = TranslationCacheManager.getCache("CACHE_L2");
            if (c != null) {
                c.put(key, o);
            }
        }
    }

    private FormatCacheItem getFormattings(String key) {
        Object o = null;
        TranslationCacheManager.getInstance();
        Cache c = TranslationCacheManager.getCache("CACHE_L2");
        if (c != null) {
            return (FormatCacheItem)c.get(key);
        }
        return null;
    }
}

