/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.ProductOpt;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.CacheService;
import com.vmware.vipclient.i18n.messages.service.ComponentService;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductService {
    private BaseDTO dto = null;
    Logger logger = LoggerFactory.getLogger(ProductService.class);

    public ProductService(BaseDTO dto) {
        this.dto = dto;
    }

    public List<Map> getAllComponentTranslation() {
        ArrayList<Map> list = new ArrayList<Map>();
        Set<String> locales = this.getSupportedLocales();
        List<String> components = this.getComponents();
        if (locales != null && components != null) {
            for (String locale : locales) {
                for (String component : components) {
                    MessagesDTO msgDTO = new MessagesDTO(component.trim(), LocaleUtility.fmtToMappedLocale(locale).toString().trim(), this.dto.getProductID(), this.dto.getVersion());
                    Map<String, String> retMap = new ComponentService(msgDTO).getMessages(null).getCachedData();
                    if (retMap == null) continue;
                    list.add(retMap);
                }
            }
        }
        return list;
    }

    public List<String> getComponents() {
        List<String> components = null;
        Iterator<DataSourceEnum> msgSourceQueueIter = VIPCfg.getInstance().getMsgOriginsQueue().iterator();
        while ((components == null || components.isEmpty()) && msgSourceQueueIter.hasNext()) {
            DataSourceEnum dataSource = msgSourceQueueIter.next();
            ProductOpt opt = dataSource.createProductOpt(this.dto);
            components = opt.getComponents();
            if (components != null && !components.isEmpty()) continue;
            this.logger.error("Failed to get list of components from {0} data source", (Object)dataSource.toString());
        }
        return components;
    }

    private Set<String> getSupportedLocales() {
        return this.combineSupportedLocales(true);
    }

    public Set<String> getCachedSupportedLocales() {
        return this.combineSupportedLocales(false);
    }

    private Set<String> combineSupportedLocales(boolean refreshCache) {
        Iterator<DataSourceEnum> msgSourceQueueIter = VIPCfg.getInstance().getMsgOriginsQueue().iterator();
        HashSet<String> supportedLangTags = new HashSet<String>();
        while (msgSourceQueueIter.hasNext()) {
            if (refreshCache) {
                supportedLangTags.addAll(this.getSupportedLocales(msgSourceQueueIter.next()));
                continue;
            }
            supportedLangTags.addAll(this.getCachedSupportedLocales(msgSourceQueueIter.next()));
        }
        return supportedLangTags;
    }

    public Set<String> getCachedSupportedLocales(DataSourceEnum dataSource) {
        return this.processSupportedLocales(dataSource, false);
    }

    public Set<String> getSupportedLocales(DataSourceEnum dataSource) {
        return this.processSupportedLocales(dataSource, true);
    }

    private Set<String> processSupportedLocales(DataSourceEnum dataSource, boolean waitFetchFromDS) {
        CacheService cs = new CacheService(new MessagesDTO(this.dto));
        MessageCacheItem cacheItem = cs.getCacheOfLocales(dataSource);
        if (cacheItem != null) {
            if (cacheItem.isExpired()) {
                this.refreshLocalesCacheItemTask(cacheItem, dataSource);
            }
            return cacheItem.getCachedData().keySet();
        }
        if (waitFetchFromDS) {
            cacheItem = this.createLocalesCacheItem(dataSource);
        } else {
            this.createLocalesCacheItemTask(dataSource);
        }
        if (cacheItem == null) {
            return new HashSet<String>();
        }
        return cacheItem.getCachedData().keySet();
    }

    private void refreshLocalesCacheItem(MessageCacheItem cacheItem, DataSourceEnum dataSource) {
        long timestampOld = cacheItem.getTimestamp();
        dataSource.createProductOpt(this.dto).getSupportedLocales(cacheItem);
        long timestamp = cacheItem.getTimestamp();
        if (timestampOld == timestamp) {
            this.logger.debug(FormatUtils.format("Failed to get list of locales from {0} data source", dataSource.toString()));
        }
    }

    private void refreshLocalesCacheItemTask(MessageCacheItem cacheItem, DataSourceEnum dataSource) {
        Callable<MessageCacheItem> callable = () -> {
            try {
                this.refreshLocalesCacheItem(cacheItem, dataSource);
                return cacheItem;
            }
            catch (Exception e) {
                return null;
            }
        };
        FutureTask<MessageCacheItem> task = new FutureTask<MessageCacheItem>(callable);
        Thread thread = new Thread(task);
        thread.start();
    }

    private MessageCacheItem createLocalesCacheItem(DataSourceEnum dataSource) {
        CacheService cs = new CacheService(new MessagesDTO(this.dto));
        MessageCacheItem cacheItem = new MessageCacheItem();
        this.refreshLocalesCacheItem(cacheItem, dataSource);
        if (!cacheItem.getCachedData().isEmpty()) {
            cs.addCacheOfLocales(cacheItem, dataSource);
            return cacheItem;
        }
        return null;
    }

    private void createLocalesCacheItemTask(DataSourceEnum dataSource) {
        Runnable runnable = () -> {
            try {
                this.createLocalesCacheItem(dataSource);
            }
            catch (Exception e) {
                this.logger.error("Failed to refresh list of supported locales for data source " + (Object)((Object)dataSource));
            }
        };
        new Thread(runnable).start();
    }
}

