/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LocaleUtility {
    private static Locale defaultLocale;
    private static Locale sourceLocale;
    private static List<Locale> fallbackLocales;
    private static InheritableThreadLocal<Map<String, Locale>> threadLocal;

    public static void setLocale(Locale locale) {
        Map localeMap = (Map)threadLocal.get();
        localeMap.put("LOCALE_L3", locale);
        threadLocal.set(localeMap);
    }

    public static Locale getLocale() {
        Map localeMap = (Map)threadLocal.get();
        Locale locale = (Locale)localeMap.get("LOCALE_L3");
        if (locale == null) {
            return defaultLocale;
        }
        return locale;
    }

    public static void setL2Locale(Locale locale) {
        Map localeMap = (Map)threadLocal.get();
        localeMap.put("LOCALE_L2", locale);
        threadLocal.set(localeMap);
    }

    public static Locale getL2Locale() {
        Map localeMap = (Map)threadLocal.get();
        Locale locale = (Locale)localeMap.get("LOCALE_L2");
        if (locale == null) {
            return defaultLocale;
        }
        return locale;
    }

    public static boolean isDefaultLocale(Locale locale) {
        if (locale != null) {
            return LocaleUtility.isDefaultLocale(locale.toLanguageTag());
        }
        return false;
    }

    public static boolean isDefaultLocale(String languageTag) {
        languageTag = languageTag.replaceAll("_", "-");
        Locale match = Locale.lookup(Arrays.asList(new Locale.LanguageRange(languageTag)), Arrays.asList(LocaleUtility.getDefaultLocale()));
        return match != null;
    }

    public static Locale fmtToMappedLocale(String zhLocale) {
        return LocaleUtility.fmtToMappedLocale(Locale.forLanguageTag(zhLocale.replace("_", "-")));
    }

    public static Locale fmtToMappedLocale(Locale zhLocale) {
        if (zhLocale.toLanguageTag().equalsIgnoreCase("zh-CN") || zhLocale.toLanguageTag().equalsIgnoreCase("zh-Hans-CN")) {
            return Locale.forLanguageTag("zh-Hans");
        }
        if (zhLocale.toLanguageTag().equalsIgnoreCase("zh-TW") || zhLocale.toLanguageTag().equalsIgnoreCase("zh-Hant-TW")) {
            return Locale.forLanguageTag("zh-HANT");
        }
        return zhLocale;
    }

    public static Locale pickupLocaleFromList(Set<Locale> locales, Locale preferredLocale) {
        Locale localeObject = LocaleUtility.fmtToMappedLocale(preferredLocale);
        Locale bestMatch = Locale.lookup(Arrays.asList(new Locale.LanguageRange(localeObject.toLanguageTag())), locales);
        if (bestMatch != null && bestMatch.getLanguage().equals("zh") && !locales.contains(localeObject)) {
            return null;
        }
        return bestMatch;
    }

    public static String normalizeToLanguageTag(String localeStr) {
        if (null == localeStr || "".equalsIgnoreCase(localeStr)) {
            return localeStr;
        }
        if (LocaleUtility.isLanguageTag(localeStr)) {
            return localeStr;
        }
        String language = "";
        String country = "";
        String script = "";
        String[] os = localeStr.split("_");
        block5: for (int i = 0; i < os.length; ++i) {
            switch (i) {
                case 0: {
                    language = os[0];
                    continue block5;
                }
                case 1: {
                    country = "".equalsIgnoreCase(os[1]) ? "" : "-" + os[1];
                    continue block5;
                }
                case 2: {
                    script = "".equalsIgnoreCase(os[2]) ? "" : "-" + os[2].replace("#", "");
                    continue block5;
                }
            }
        }
        return language + script + country;
    }

    public static boolean isLanguageTag(String languageTag) {
        if (null == languageTag || "".equalsIgnoreCase(languageTag)) {
            return false;
        }
        return languageTag.contains("-");
    }

    public static Locale getDefaultLocale() {
        return defaultLocale == null ? LocaleUtility.getSourceLocale() : defaultLocale;
    }

    public static void setDefaultLocale(Locale defaultLocale) {
        LocaleUtility.defaultLocale = defaultLocale;
    }

    public static Locale getSourceLocale() {
        return sourceLocale;
    }

    public static void setSourceLocale(Locale sourceLocale) {
        LocaleUtility.sourceLocale = sourceLocale;
    }

    public static List<Locale> getFallbackLocales() {
        return fallbackLocales;
    }

    public static void setFallbackLocales(List<Locale> fallbackLocales) {
        LocaleUtility.fallbackLocales = fallbackLocales;
    }

    public static Set<Locale> langTagtoLocaleSet(Set<String> languageTags) {
        HashSet<Locale> locales = new HashSet<Locale>();
        if (languageTags != null) {
            for (String languageTag : languageTags) {
                locales.add(Locale.forLanguageTag(languageTag));
            }
        }
        return locales;
    }

    static {
        sourceLocale = Locale.ENGLISH;
        fallbackLocales = new LinkedList<Locale>(Arrays.asList(LocaleUtility.getDefaultLocale(), Locale.forLanguageTag("source")));
        threadLocal = new InheritableThreadLocal<Map<String, Locale>>(){

            @Override
            protected Map<String, Locale> initialValue() {
                return new HashMap<String, Locale>();
            }

            @Override
            protected Map<String, Locale> childValue(Map<String, Locale> parentValue) {
                return parentValue.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Locale.Builder().setLocale((Locale)e.getValue()).build()));
            }
        };
    }
}

