/*
 * Decompiled with CFR 0.152.
 */
package com.vortexsoftware.sdk.spring;

import com.vortexsoftware.sdk.VortexClient;
import com.vortexsoftware.sdk.spring.VortexConfig;
import com.vortexsoftware.sdk.spring.VortexController;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"vortex.api.key"})
public class VortexAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VortexClient vortexClient(@Value(value="${vortex.api.key}") String apiKey, @Value(value="${vortex.api.base-url:#{null}}") String baseUrl) {
        return baseUrl != null ? new VortexClient(apiKey, baseUrl) : new VortexClient(apiKey);
    }

    @Bean
    @ConditionalOnMissingBean
    public VortexConfig vortexConfig() {
        return new DefaultVortexConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public VortexController vortexController(VortexClient vortexClient, VortexConfig vortexConfig) {
        return new VortexController(vortexClient, vortexConfig);
    }

    private static class DefaultVortexConfig
    implements VortexConfig {
        private DefaultVortexConfig() {
        }

        @Override
        public VortexConfig.VortexUser authenticateUser() {
            return null;
        }

        @Override
        public boolean authorizeOperation(String operation, VortexConfig.VortexUser user) {
            return user != null;
        }
    }
}

