/*
 * Decompiled with CFR 0.152.
 */
package com.wandrell.pattern.command;

import com.google.common.base.Preconditions;
import com.wandrell.pattern.command.Command;
import com.wandrell.pattern.command.CommandExecutor;
import com.wandrell.pattern.command.ResultCommand;
import com.wandrell.pattern.command.UndoableCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultCommandExecutor
implements CommandExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCommandExecutor.class);

    private static final Logger getLogger() {
        return LOGGER;
    }

    @Override
    public final void execute(Command command) {
        Preconditions.checkNotNull((Object)command, (Object)"Received a null pointer as command");
        try {
            command.execute();
        }
        catch (RuntimeException exception) {
            DefaultCommandExecutor.getLogger().error(exception.getMessage());
            throw exception;
        }
        catch (Exception exception) {
            DefaultCommandExecutor.getLogger().error(exception.getMessage());
            throw new RuntimeException(exception);
        }
    }

    @Override
    public final <V> V execute(ResultCommand<V> command) {
        Preconditions.checkNotNull(command, (Object)"Received a null pointer as command");
        this.execute((Command)command);
        return command.getResult();
    }

    @Override
    public final void undo(UndoableCommand command) {
        try {
            command.undo();
        }
        catch (RuntimeException exception) {
            DefaultCommandExecutor.getLogger().error(exception.getMessage());
            throw exception;
        }
        catch (Exception exception) {
            DefaultCommandExecutor.getLogger().error(exception.getMessage());
            throw new RuntimeException(exception);
        }
    }
}

