/*
 * Decompiled with CFR 0.152.
 */
package com.wandrell.pattern.outputter.xml;

import com.google.common.base.Preconditions;
import com.wandrell.pattern.conf.XMLValidationType;
import com.wandrell.pattern.outputter.Outputter;
import java.io.OutputStream;
import java.io.Writer;
import org.jdom2.Attribute;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;

public final class XMLOutputter
implements Outputter<Document> {
    private static final String ELEMENT_VALID = "validator";
    private static final String NAMESPACE_PREFIX = "xsi";
    private static final String NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSD_ATTRIBUTE = "noNamespaceSchemaLocation";
    private String valFilePath;
    private XMLValidationType validationType;

    public XMLOutputter() {
        this(XMLValidationType.NONE, "");
    }

    public XMLOutputter(XMLValidationType validation, String validationPath) {
        Preconditions.checkNotNull((Object)((Object)validation), (Object)"Received a null pointer as validation type");
        Preconditions.checkNotNull((Object)validationPath, (Object)"Received a null pointer as validation path");
        this.validationType = validation;
        this.valFilePath = validationPath;
    }

    @Override
    public final void output(Document value, OutputStream stream) throws Exception {
        Preconditions.checkNotNull((Object)value, (Object)"Received a null pointer as value");
        Preconditions.checkNotNull((Object)stream, (Object)"Received a null pointer as output stream");
        Document doc = value.clone();
        this.setValidation(doc);
        new org.jdom2.output.XMLOutputter(Format.getPrettyFormat()).output(doc, stream);
    }

    @Override
    public final void output(Document value, Writer writer) throws Exception {
        Preconditions.checkNotNull((Object)value, (Object)"Received a null pointer as value");
        Preconditions.checkNotNull((Object)writer, (Object)"Received a null pointer as writer");
        Document doc = value.clone();
        this.setValidation(doc);
        new org.jdom2.output.XMLOutputter(Format.getPrettyFormat()).output(doc, writer);
    }

    public final void setValidation(XMLValidationType validation, String path) {
        Preconditions.checkNotNull((Object)((Object)validation), (Object)"Received a null pointer as validation type");
        Preconditions.checkNotNull((Object)path, (Object)"Received a null pointer as validation path");
        this.validationType = validation;
        this.valFilePath = path;
    }

    private final String getDTDValidatorName() {
        return ELEMENT_VALID;
    }

    private final String getValidationPath() {
        return this.valFilePath;
    }

    private final XMLValidationType getValidationType() {
        return this.validationType;
    }

    private final String getXSDAttribute() {
        return XSD_ATTRIBUTE;
    }

    private final Namespace getXSDNamespace() {
        return Namespace.getNamespace((String)NAMESPACE_PREFIX, (String)NAMESPACE_URI);
    }

    private final void setValidation(Document doc) {
        switch (this.getValidationType()) {
            case XSD: {
                Element root = doc.getRootElement();
                Namespace namespc = this.getXSDNamespace();
                root.addNamespaceDeclaration(namespc);
                root.setAttribute(new Attribute(this.getXSDAttribute(), this.getValidationPath(), namespc));
                break;
            }
            case DTD: {
                doc.setDocType(new DocType(this.getDTDValidatorName(), this.getValidationPath()));
                break;
            }
        }
    }
}

