/*
 * Decompiled with CFR 0.152.
 */
package com.wandrell.pattern.parser.xml;

import com.google.common.base.Preconditions;
import com.wandrell.pattern.parser.Parser;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jdom2.Document;

public abstract class AbstractAttributesFilterXMLFileParser
implements Parser<Reader, Document> {
    private final Collection<String> attrRejected = new LinkedHashSet<String>();
    private final Collection<String> attrRequired = new LinkedHashSet<String>();

    public final void addRejectedAttribute(String attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Received a null pointer as attribute");
        if (attribute.length() > 0) {
            this.getRejectedAttributesModifiable().add(attribute);
            this.onAttributesChange();
        }
    }

    public final void addRequiredAttribute(String attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Received a null pointer as attribute");
        if (attribute.length() > 0) {
            this.getRequiredAttributesModifiable().add(attribute);
            this.onAttributesChange();
        }
    }

    public final void clearRejectedAttributes() {
        this.getRejectedAttributesModifiable().clear();
        this.onAttributesChange();
    }

    public final void clearRequiredAttributes() {
        this.getRequiredAttributesModifiable().clear();
        this.onAttributesChange();
    }

    public final Collection<String> getRejectedAttributes() {
        return Collections.unmodifiableCollection(this.getRejectedAttributesModifiable());
    }

    public final Collection<String> getRequiredAttributes() {
        return Collections.unmodifiableCollection(this.getRequiredAttributesModifiable());
    }

    public final void removeRejectedAttribute(String attribute) {
        this.getRejectedAttributesModifiable().remove(attribute);
        this.onAttributesChange();
    }

    public final void removeRequiredAttribute(String attribute) {
        this.getRequiredAttributesModifiable().remove(attribute);
        this.onAttributesChange();
    }

    protected final Collection<String> getRejectedAttributesModifiable() {
        return this.attrRejected;
    }

    protected final Collection<String> getRequiredAttributesModifiable() {
        return this.attrRequired;
    }

    protected abstract void onAttributesChange();
}

