/*
 * Decompiled with CFR 0.152.
 */
package com.wandrell.pattern.repository;

import com.google.common.base.Preconditions;
import com.wandrell.pattern.repository.QueryData;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DefaultQueryData
implements QueryData {
    private final Map<String, Object> params;
    private final String queryStr;

    public DefaultQueryData(String query) {
        this(query, new LinkedHashMap<String, Object>());
    }

    public DefaultQueryData(String query, Map<String, Object> parameters) {
        Preconditions.checkNotNull((Object)query, (Object)"Received a null pointer as query");
        Preconditions.checkNotNull(parameters, (Object)"Received a null pointer as parameters");
        this.queryStr = query;
        this.params = parameters;
    }

    @Override
    public final Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public final String getQuery() {
        return this.queryStr;
    }
}

