/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations;

import com.wavefront.integrations.WavefrontConnectionHandler;
import com.wavefront.metrics.ReconnectingSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;

public abstract class AbstractProxyConnectionHandler
implements WavefrontConnectionHandler {
    private final InetSocketAddress address;
    private final SocketFactory socketFactory;
    private volatile ReconnectingSocket reconnectingSocket;

    protected AbstractProxyConnectionHandler(InetSocketAddress address, SocketFactory socketFactory) {
        this.address = address;
        this.socketFactory = socketFactory;
        this.reconnectingSocket = null;
    }

    @Override
    public synchronized void connect() throws IllegalStateException, IOException {
        if (this.reconnectingSocket != null) {
            throw new IllegalStateException("Already connected");
        }
        try {
            this.reconnectingSocket = new ReconnectingSocket(this.address.getHostName(), this.address.getPort(), this.socketFactory);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.reconnectingSocket != null;
    }

    @Override
    public void flush() throws IOException {
        if (this.reconnectingSocket != null) {
            this.reconnectingSocket.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.reconnectingSocket != null) {
            this.reconnectingSocket.close();
            this.reconnectingSocket = null;
        }
    }

    protected void sendData(String lineData) throws Exception {
        this.reconnectingSocket.write(lineData);
    }
}

