/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.wavefront.api.agent.AgentConfiguration;
import com.wavefront.api.agent.ShellOutputDTO;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.GZIP;

@Path(value="daemon/")
public interface AgentAPI {
    @GET
    @Path(value="{agentId}/config")
    @Produces(value={"application/json"})
    public AgentConfiguration getConfig(@PathParam(value="agentId") UUID var1, @QueryParam(value="hostname") String var2, @QueryParam(value="currentMillis") Long var3, @QueryParam(value="bytesLeftForBuffer") Long var4, @QueryParam(value="bytesPerMinuteForBuffer") Long var5, @QueryParam(value="currentQueueSize") Long var6, @QueryParam(value="token") String var7, @QueryParam(value="version") String var8);

    @POST
    @Path(value="{sshDaemonId}/checkin")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AgentConfiguration checkin(@PathParam(value="sshDaemonId") UUID var1, @QueryParam(value="hostname") String var2, @QueryParam(value="token") String var3, @QueryParam(value="version") String var4, @QueryParam(value="currentMillis") Long var5, @QueryParam(value="local") Boolean var6, @GZIP JsonNode var7, @QueryParam(value="push") Boolean var8);

    @POST
    @Consumes(value={"text/plain"})
    @Path(value="{agentId}/pushdata/{workUnitId}")
    public Response postPushData(@PathParam(value="agentId") UUID var1, @PathParam(value="workUnitId") UUID var2, @Deprecated @QueryParam(value="currentMillis") Long var3, @QueryParam(value="format") String var4, @GZIP String var5);

    @POST
    @Path(value="{agentId}/error")
    public void agentError(@PathParam(value="agentId") UUID var1, @FormParam(value="details") String var2);

    @POST
    @Path(value="{agentId}/config/processed")
    public void agentConfigProcessed(@PathParam(value="agentId") UUID var1);

    @POST
    @Consumes(value={"application/json"})
    @Path(value="{agentId}/workunit/{workUnitId}/{hostId}")
    public Response postWorkUnitResult(@PathParam(value="agentId") UUID var1, @PathParam(value="workUnitId") UUID var2, @PathParam(value="hostId") UUID var3, @GZIP ShellOutputDTO var4);

    @POST
    @Path(value="{agentId}/host/{hostId}/fail")
    public void hostConnectionFailed(@PathParam(value="agentId") UUID var1, @PathParam(value="hostId") UUID var2, @FormParam(value="details") String var3);

    @POST
    @Path(value="{agentId}/host/{hostId}/connect")
    public void hostConnectionEstablished(@PathParam(value="agentId") UUID var1, @PathParam(value="hostId") UUID var2);

    @POST
    @Path(value="{agentId}/host/{hostId}/auth")
    public void hostAuthenticated(@PathParam(value="agentId") UUID var1, @PathParam(value="hostId") UUID var2);
}

