/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.wavefront.ingester.Decoder;
import com.wavefront.ingester.IngesterFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import sunnylabs.report.ReportPoint;

public class GraphiteDecoder
implements Decoder {
    private static final Pattern CUSTOMERID = Pattern.compile("[a-z]+");
    private static final IngesterFormatter FORMAT = IngesterFormatter.newBuilder().whiteSpace().appendMetricName().whiteSpace().appendValue().whiteSpace().appendOptionalTimestamp().whiteSpace().appendAnnotationsConsumer().whiteSpace().build();
    private final String hostName;

    public GraphiteDecoder() {
        this.hostName = "unknown";
    }

    public GraphiteDecoder(String hostName) {
        Preconditions.checkNotNull((Object)hostName);
        this.hostName = hostName;
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId) {
        ReportPoint point = FORMAT.drive(msg, this.hostName, customerId);
        if (out != null) {
            out.add(point);
        }
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out) {
        ArrayList output = Lists.newArrayList();
        this.decodeReportPoints(msg, output, "dummy");
        if (!output.isEmpty()) {
            for (ReportPoint rp : output) {
                String metricName = rp.getMetric();
                ArrayList metricParts = Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)metricName));
                if (metricParts.size() <= 1) {
                    throw new RuntimeException("Metric name does not contain a customer id: " + metricName);
                }
                String customerId = (String)metricParts.get(0);
                if (CUSTOMERID.matcher(customerId).matches()) {
                    metricName = Joiner.on((String)".").join(metricParts.subList(1, metricParts.size()));
                }
                out.add(ReportPoint.newBuilder(rp).setMetric(metricName).setTable(customerId).build());
            }
        }
    }
}

