/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.wavefront.ingester.TcpIngester;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class StringLineIngester
extends TcpIngester {
    private static final String PUSH_DATA_DELIMETER = "\n";

    public StringLineIngester(List<Function<Channel, ChannelHandler>> decoders, ChannelHandler commandHandler, int port) {
        super(StringLineIngester.createDecoderList(decoders), commandHandler, port);
    }

    public StringLineIngester(ChannelHandler commandHandler, int port) {
        super(StringLineIngester.createDecoderList(null), commandHandler, port);
    }

    private static List<Function<Channel, ChannelHandler>> createDecoderList(@Nullable List<Function<Channel, ChannelHandler>> decoders) {
        ArrayList<Object> copy = decoders == null ? new ArrayList() : new ArrayList<Function<Channel, ChannelHandler>>(decoders);
        copy.add(0, new Function<Channel, ChannelHandler>(){

            public ChannelHandler apply(Channel input) {
                return new LineBasedFrameDecoder(4096, true, true);
            }
        });
        copy.add(1, new Function<Channel, ChannelHandler>(){

            public ChannelHandler apply(Channel input) {
                return new StringDecoder(Charsets.UTF_8);
            }
        });
        return copy;
    }

    public static List<String> unjoinPushData(String pushData) {
        return Arrays.asList(StringUtils.split((String)pushData, (String)PUSH_DATA_DELIMETER));
    }

    public static String joinPushData(List<String> pushData) {
        return StringUtils.join(pushData, (String)PUSH_DATA_DELIMETER);
    }
}

