/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.api.agent;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.wavefront.api.agent.MetricStage;
import java.util.Set;
import java.util.UUID;

public class WorkUnit {
    public UUID id;
    public String name;
    public long delay;
    public String command;
    public MetricStage stage;
    public Set<UUID> targets = Sets.newHashSet();

    public void validate() {
        Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null for a work unit");
        Preconditions.checkNotNull((Object)this.name, (Object)"name cannot be null for a work unit");
        Preconditions.checkNotNull(this.targets, (Object)("targets cannot be null for work unit: " + this.name));
        Preconditions.checkNotNull((Object)this.command, (Object)("command must not be null for work unit: " + this.name));
        Preconditions.checkNotNull((Object)((Object)this.stage), (Object)("stage cannot be null for work unit: " + this.name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkUnit workUnit = (WorkUnit)o;
        if (this.delay != workUnit.delay) {
            return false;
        }
        if (this.command != null ? !this.command.equals(workUnit.command) : workUnit.command != null) {
            return false;
        }
        if (!this.id.equals(workUnit.id)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(workUnit.name) : workUnit.name != null) {
            return false;
        }
        if (this.targets != null ? !this.targets.equals(workUnit.targets) : workUnit.targets != null) {
            return false;
        }
        return !(this.stage != null ? !this.stage.equals((Object)workUnit.stage) : workUnit.stage != null);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
        result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
        result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
        result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
        return result;
    }

    public WorkUnit clone() {
        WorkUnit cloned = new WorkUnit();
        cloned.delay = this.delay;
        cloned.name = this.name;
        cloned.command = this.command;
        cloned.targets = Sets.newHashSet(this.targets);
        cloned.stage = this.stage;
        cloned.id = this.id;
        return cloned;
    }
}

