/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import queryserver.parser.DSWrapperLexer;
import sunnylabs.report.ReportPoint;

public class IngesterFormatter {
    private static final FormatterElement WHITESPACE_ELEMENT = new Whitespace();
    private final List<FormatterElement> elements;

    private IngesterFormatter(List<FormatterElement> elements) {
        this.elements = elements;
    }

    public ReportPoint drive(String input, String defaultHostName, String customerId) {
        DSWrapperLexer lexer = new DSWrapperLexer((CharStream)new ANTLRInputStream(input));
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new RuntimeException(msg, (Throwable)e);
            }
        });
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        commonTokenStream.getText();
        List tokens = commonTokenStream.getTokens();
        if (tokens.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        ArrayDeque<Token> queue = new ArrayDeque<Token>(Lists.newArrayList((Iterable)Iterables.filter((Iterable)tokens, (Predicate)new Predicate<Token>(){

            public boolean apply(Token input) {
                return input.getType() != -1;
            }
        })));
        ReportPoint point = new ReportPoint();
        point.setTable(customerId);
        point.setTimestamp(System.currentTimeMillis());
        try {
            for (FormatterElement element : this.elements) {
                element.consume(queue, point);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        if (!queue.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        String host = null;
        Map<String, String> annotations = point.getAnnotations();
        if (annotations != null) {
            host = annotations.remove("source");
            if (host == null) {
                host = annotations.remove("host");
            } else if (annotations.containsKey("host")) {
                annotations.put("_host", annotations.remove("host"));
            }
            if (annotations.containsKey("tag")) {
                annotations.put("_tag", annotations.remove("tag"));
            }
            if (host == null) {
                host = annotations.remove("fqdn");
            }
        }
        if (host == null) {
            host = defaultHostName;
        }
        point.setHost(host);
        return point;
    }

    public static IngesterFormatBuilder newBuilder() {
        return new IngesterFormatBuilder();
    }

    private static String getLiteral(Queue<Token> tokens) {
        String toReturn = "";
        Token next = tokens.peek();
        if (next == null) {
            return "";
        }
        if (next.getType() == 9) {
            return IngesterFormatter.unquote(tokens.poll().getText());
        }
        while (next != null && (next.getType() == 8 || next.getType() == 7 || next.getType() == 10 || next.getType() == 3 || next.getType() == 4 || next.getType() == 6)) {
            toReturn = toReturn + tokens.poll().getText();
            next = tokens.peek();
        }
        return toReturn;
    }

    private static String unquote(String text) {
        if (text.startsWith("\"")) {
            text = text.substring(1, text.length() - 1).replace("\\\"", "\"");
        } else if (text.startsWith("'")) {
            text = text.substring(1, text.length() - 1).replace("\\'", "'");
        }
        return text;
    }

    public static class Literal
    implements FormatterElement {
        private final String literal;
        private final boolean caseSensitive;

        public Literal(String literal, boolean caseSensitive) {
            this.literal = literal;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            if (tokenQueue.isEmpty()) {
                throw new RuntimeException("Expecting a literal string: " + this.literal + " but found EOF");
            }
            String literal = IngesterFormatter.getLiteral(tokenQueue);
            if (this.caseSensitive ? !literal.equals(this.literal) : !literal.equalsIgnoreCase(this.literal)) {
                throw new RuntimeException("Expecting a literal string: " + literal + " but found: " + literal);
            }
        }
    }

    public static class Whitespace
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokens, ReportPoint point) {
            while (!tokens.isEmpty() && tokens.peek().getType() == 13) {
                tokens.poll();
            }
        }
    }

    public static class Metric
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            String metric = IngesterFormatter.getLiteral(tokenQueue);
            if (metric.length() == 0) {
                throw new RuntimeException("Invalid metric name");
            }
            point.setMetric(metric);
        }
    }

    public static class Timestamp
    implements FormatterElement {
        private final TimeUnit timeUnit;
        private final boolean optional;

        public Timestamp(TimeUnit timeUnit, boolean optional) {
            this.timeUnit = timeUnit;
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            Token peek = tokenQueue.peek();
            if (peek == null) {
                if (this.optional) {
                    return;
                }
                throw new RuntimeException("Expecting timestamp, found EOF");
            }
            if (peek.getType() == 7) {
                try {
                    long multiplier = this.timeUnit.toMillis(1L);
                    if (multiplier < 1L) {
                        point.setTimestamp(this.timeUnit.toMillis((long)Double.parseDouble(tokenQueue.poll().getText())));
                    }
                    point.setTimestamp((long)((double)multiplier * Double.parseDouble(tokenQueue.poll().getText())));
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Invalid timestamp value: " + peek.getText());
                }
            } else if (!this.optional) {
                throw new RuntimeException("Expecting timestamp, found: " + peek.getText());
            }
        }
    }

    public static class AdaptiveTimestamp
    implements FormatterElement {
        private final boolean optional;

        public AdaptiveTimestamp(boolean optional) {
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            Token peek = tokenQueue.peek();
            if (peek == null) {
                if (this.optional) {
                    return;
                }
                throw new RuntimeException("Expecting timestamp, found EOF");
            }
            if (peek.getType() == 7) {
                try {
                    Double timestamp = Double.parseDouble(tokenQueue.poll().getText());
                    Long timestampLong = timestamp.longValue();
                    if (timestampLong.toString().length() == 13) {
                        point.setTimestamp(timestamp.longValue());
                    }
                    point.setTimestamp((long)(1000.0 * timestamp));
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Invalid timestamp value: " + peek.getText());
                }
            } else if (!this.optional) {
                throw new RuntimeException("Expecting timestamp, found: " + peek.getText());
            }
        }
    }

    public static class Value
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            String value = "";
            Token current = tokenQueue.poll();
            if (current == null) {
                throw new RuntimeException("Invalid metric value, found EOF");
            }
            if (current.getType() == 4) {
                current = tokenQueue.poll();
                value = "-";
            }
            if (current == null) {
                throw new RuntimeException("Invalid metric value, found EOF");
            }
            if (current.getType() == 9) {
                if (!value.equals("")) {
                    throw new RuntimeException("invalid metric value: " + value + current.getText());
                }
                value = value + IngesterFormatter.unquote(current.getText());
            } else if (current.getType() == 8 || current.getType() == 10 || current.getType() == 7) {
                value = value + current.getText();
            } else {
                throw new RuntimeException("invalid metric value: " + current.getText());
            }
            try {
                point.setValue(Double.parseDouble(value));
            }
            catch (NumberFormatException nef) {
                throw new RuntimeException("invalid metric value: " + value);
            }
        }
    }

    public static class Tag
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> queue, ReportPoint point) {
            String tagk = IngesterFormatter.getLiteral(queue);
            if (tagk.length() == 0) {
                throw new RuntimeException("Invalid tag name");
            }
            WHITESPACE_ELEMENT.consume(queue, point);
            Token current = queue.poll();
            if (current == null || current.getType() != 1) {
                throw new RuntimeException("Tag keys and values must be separated by '='" + (current != null ? ", found: " + current.getText() : ", found EOF"));
            }
            WHITESPACE_ELEMENT.consume(queue, point);
            String tagv = IngesterFormatter.getLiteral(queue);
            if (tagv.length() == 0) {
                throw new RuntimeException("Invalid tag value for: " + tagk);
            }
            if (point.getAnnotations() == null) {
                point.setAnnotations(Maps.newHashMap());
            }
            point.getAnnotations().put(tagk, tagv);
        }
    }

    public static class Loop
    implements FormatterElement {
        private final FormatterElement element;

        public Loop(FormatterElement element) {
            this.element = element;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            while (!tokenQueue.isEmpty()) {
                WHITESPACE_ELEMENT.consume(tokenQueue, point);
                if (tokenQueue.isEmpty()) {
                    return;
                }
                this.element.consume(tokenQueue, point);
            }
        }
    }

    private static interface FormatterElement {
        public void consume(Queue<Token> var1, ReportPoint var2);
    }

    public static class IngesterFormatBuilder {
        private final List<FormatterElement> elements = Lists.newArrayList();

        public IngesterFormatBuilder appendCaseSensitiveLiteral(String literal) {
            this.elements.add(new Literal(literal, true));
            return this;
        }

        public IngesterFormatBuilder appendCaseInsensitiveLiteral(String literal) {
            this.elements.add(new Literal(literal, false));
            return this;
        }

        public IngesterFormatBuilder appendMetricName() {
            this.elements.add(new Metric());
            return this;
        }

        public IngesterFormatBuilder appendValue() {
            this.elements.add(new Value());
            return this;
        }

        public IngesterFormatBuilder appendTimestamp() {
            this.elements.add(new AdaptiveTimestamp(false));
            return this;
        }

        public IngesterFormatBuilder appendOptionalTimestamp() {
            this.elements.add(new AdaptiveTimestamp(true));
            return this;
        }

        public IngesterFormatBuilder appendTimestamp(TimeUnit timeUnit) {
            this.elements.add(new Timestamp(timeUnit, false));
            return this;
        }

        public IngesterFormatBuilder appendOptionalTimestamp(TimeUnit timeUnit) {
            this.elements.add(new Timestamp(timeUnit, true));
            return this;
        }

        public IngesterFormatBuilder appendAnnotationsConsumer() {
            this.elements.add(new Loop(new Tag()));
            return this;
        }

        public IngesterFormatBuilder whiteSpace() {
            this.elements.add(new Whitespace());
            return this;
        }

        public IngesterFormatter build() {
            return new IngesterFormatter(this.elements);
        }
    }
}

