/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamIngester
implements Runnable {
    protected static final Logger logger = Logger.getLogger(StreamIngester.class.getName());
    private final ChannelHandler commandHandler;
    private final int listeningPort;
    private final FrameDecoderFactory frameDecoderFactory;

    public StreamIngester(FrameDecoderFactory frameDecoderFactory, ChannelHandler commandHandler, int port) {
        this.listeningPort = port;
        this.commandHandler = commandHandler;
        this.frameDecoderFactory = frameDecoderFactory;
    }

    @Override
    public void run() {
        ServerBootstrap b = new ServerBootstrap();
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)new NioEventLoopGroup(1), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).localAddress(this.listeningPort)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("frame decoder", (ChannelHandler)StreamIngester.this.frameDecoderFactory.getDecoder());
                    pipeline.addLast("byte array decoder", (ChannelHandler)new ByteArrayDecoder());
                    pipeline.addLast(new ChannelHandler[]{StreamIngester.this.commandHandler});
                }
            });
            ChannelFuture f = b.bind().sync();
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Interrupted", e);
        }
    }

    public static interface FrameDecoderFactory {
        public ChannelInboundHandler getDecoder();
    }
}

