/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.metrics;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.stats.Snapshot;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class JsonMetricsGenerator {
    private static final JsonFactory factory = new JsonFactory();
    private static final Clock clock = Clock.defaultClock();
    private static final VirtualMachineMetrics vm = VirtualMachineMetrics.getInstance();
    private static final Pattern SIMPLE_NAMES = Pattern.compile("[^a-zA-Z0-9_.\\-~]");

    public static void generateJsonMetrics(OutputStream outputStream, MetricsRegistry registry, boolean includeVMMetrics, boolean includeBuildMetrics, boolean clearMetrics) throws IOException {
        JsonGenerator json = factory.createGenerator(outputStream, JsonEncoding.UTF8);
        JsonMetricsGenerator.writeJson(json, registry, includeVMMetrics, includeBuildMetrics, clearMetrics);
    }

    public static JsonNode generateJsonMetrics(MetricsRegistry registry, boolean includeVMMetrics, boolean includeBuildMetrics, boolean clearMetrics) throws IOException {
        TokenBuffer t = new TokenBuffer((ObjectCodec)new ObjectMapper());
        JsonMetricsGenerator.writeJson((JsonGenerator)t, registry, includeVMMetrics, includeBuildMetrics, clearMetrics);
        JsonParser parser = t.asParser();
        return (JsonNode)parser.readValueAsTree();
    }

    public static void writeJson(JsonGenerator json, MetricsRegistry registry, boolean includeVMMetrics, boolean includeBuildMetrics, boolean clearMetrics) throws IOException {
        json.writeStartObject();
        if (includeVMMetrics) {
            JsonMetricsGenerator.writeVmMetrics(json);
        }
        if (includeBuildMetrics) {
            try {
                JsonMetricsGenerator.writeBuildMetrics(ResourceBundle.getBundle("build"), json);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        JsonMetricsGenerator.writeRegularMetrics(new Processor(clearMetrics), json, registry, false);
        json.writeEndObject();
        json.close();
    }

    private static void writeBuildMetrics(ResourceBundle props, JsonGenerator json) throws IOException {
        json.writeFieldName("build");
        json.writeStartObject();
        if (props.containsKey("build.version")) {
            int version = JsonMetricsGenerator.extractVersion(props.getString("build.version"));
            if (version != 0) {
                json.writeNumberField("version", version);
            }
            json.writeStringField("version_raw", props.getString("build.version"));
        }
        if (props.containsKey("build.commit")) {
            json.writeStringField("commit", props.getString("build.commit"));
        }
        if (props.containsKey("build.hostname")) {
            json.writeStringField("build_host", props.getString("build.hostname"));
        }
        if (props.containsKey("maven.build.timestamp")) {
            if (StringUtils.isNumeric((String)props.getString("maven.build.timestamp"))) {
                json.writeNumberField("timestamp", Long.valueOf(props.getString("maven.build.timestamp")).longValue());
            }
            json.writeStringField("timestamp_raw", props.getString("maven.build.timestamp"));
        }
        json.writeEndObject();
    }

    static int extractVersion(String versionStr) {
        int version = 0;
        String[] components = versionStr.split("\\.");
        for (int i = 0; i < Math.min(3, components.length); ++i) {
            String component = components[i];
            if (StringUtils.isNotBlank((String)component) && StringUtils.isNumeric((String)component)) {
                version *= 1000;
                version += Integer.valueOf(component).intValue();
                continue;
            }
            version = 0;
            break;
        }
        if (components.length == 2) {
            version *= 1000;
        } else if (components.length == 1) {
            version *= 1000000;
        }
        return version;
    }

    private static void writeVmMetrics(JsonGenerator json) throws IOException {
        json.writeFieldName("jvm");
        json.writeStartObject();
        json.writeFieldName("vm");
        json.writeStartObject();
        json.writeStringField("name", vm.name());
        json.writeStringField("version", vm.version());
        json.writeEndObject();
        json.writeFieldName("memory");
        json.writeStartObject();
        json.writeNumberField("totalInit", vm.totalInit());
        json.writeNumberField("totalUsed", vm.totalUsed());
        json.writeNumberField("totalMax", vm.totalMax());
        json.writeNumberField("totalCommitted", vm.totalCommitted());
        json.writeNumberField("heapInit", vm.heapInit());
        json.writeNumberField("heapUsed", vm.heapUsed());
        json.writeNumberField("heapMax", vm.heapMax());
        json.writeNumberField("heapCommitted", vm.heapCommitted());
        json.writeNumberField("heap_usage", vm.heapUsage());
        json.writeNumberField("non_heap_usage", vm.nonHeapUsage());
        json.writeFieldName("memory_pool_usages");
        json.writeStartObject();
        for (Map.Entry pool : vm.memoryPoolUsage().entrySet()) {
            json.writeNumberField((String)pool.getKey(), ((Double)pool.getValue()).doubleValue());
        }
        json.writeEndObject();
        json.writeEndObject();
        Map bufferPoolStats = vm.getBufferPoolStats();
        if (!bufferPoolStats.isEmpty()) {
            json.writeFieldName("buffers");
            json.writeStartObject();
            json.writeFieldName("direct");
            json.writeStartObject();
            json.writeNumberField("count", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("direct")).getCount());
            json.writeNumberField("memoryUsed", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("direct")).getMemoryUsed());
            json.writeNumberField("totalCapacity", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("direct")).getTotalCapacity());
            json.writeEndObject();
            json.writeFieldName("mapped");
            json.writeStartObject();
            json.writeNumberField("count", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("mapped")).getCount());
            json.writeNumberField("memoryUsed", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("mapped")).getMemoryUsed());
            json.writeNumberField("totalCapacity", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("mapped")).getTotalCapacity());
            json.writeEndObject();
            json.writeEndObject();
        }
        json.writeNumberField("daemon_thread_count", vm.daemonThreadCount());
        json.writeNumberField("thread_count", vm.threadCount());
        json.writeNumberField("current_time", clock.time());
        json.writeNumberField("uptime", vm.uptime());
        json.writeNumberField("fd_usage", vm.fileDescriptorUsage());
        json.writeFieldName("thread-states");
        json.writeStartObject();
        for (Map.Entry entry : vm.threadStatePercentages().entrySet()) {
            json.writeNumberField(((Thread.State)((Object)entry.getKey())).toString().toLowerCase(), ((Double)entry.getValue()).doubleValue());
        }
        json.writeEndObject();
        json.writeFieldName("garbage-collectors");
        json.writeStartObject();
        for (Map.Entry entry : vm.garbageCollectors().entrySet()) {
            json.writeFieldName((String)entry.getKey());
            json.writeStartObject();
            VirtualMachineMetrics.GarbageCollectorStats gc = (VirtualMachineMetrics.GarbageCollectorStats)entry.getValue();
            json.writeNumberField("runs", gc.getRuns());
            json.writeNumberField("time", gc.getTime(TimeUnit.MILLISECONDS));
            json.writeEndObject();
        }
        json.writeEndObject();
        json.writeEndObject();
    }

    public static void writeRegularMetrics(Processor processor, JsonGenerator json, MetricsRegistry registry, boolean showFullSamples) throws IOException {
        for (Map.Entry entry : registry.groupedMetrics().entrySet()) {
            for (Map.Entry subEntry : ((SortedMap)entry.getValue()).entrySet()) {
                if (subEntry.getKey() instanceof TaggedMetricName) {
                    json.writeFieldName(JsonMetricsGenerator.sanitize((MetricName)subEntry.getKey()) + "$" + subEntry.hashCode());
                    json.writeStartObject();
                    json.writeFieldName("tags");
                    json.writeStartObject();
                    for (Map.Entry<String, String> tagEntry : ((TaggedMetricName)((Object)subEntry.getKey())).getTags().entrySet()) {
                        json.writeStringField(tagEntry.getKey(), tagEntry.getValue());
                    }
                    json.writeEndObject();
                    json.writeFieldName("value");
                } else {
                    json.writeFieldName(JsonMetricsGenerator.sanitize((MetricName)subEntry.getKey()));
                }
                try {
                    ((Metric)subEntry.getValue()).processWith((MetricProcessor)processor, (MetricName)subEntry.getKey(), (Object)new Context(json, showFullSamples));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!(subEntry.getKey() instanceof TaggedMetricName)) continue;
                json.writeEndObject();
            }
        }
    }

    private static Object evaluateGauge(Gauge<?> gauge) {
        try {
            return gauge.value();
        }
        catch (RuntimeException e) {
            return "error reading gauge: " + e.getMessage();
        }
    }

    private static void writeSummarizable(Summarizable metric, JsonGenerator json) throws IOException {
        json.writeNumberField("min", metric.min());
        json.writeNumberField("max", metric.max());
        json.writeNumberField("mean", metric.mean());
    }

    private static void writeSampling(Sampling metric, JsonGenerator json) throws IOException {
        Snapshot snapshot = metric.getSnapshot();
        json.writeNumberField("median", snapshot.getMedian());
        json.writeNumberField("p75", snapshot.get75thPercentile());
        json.writeNumberField("p95", snapshot.get95thPercentile());
        json.writeNumberField("p99", snapshot.get99thPercentile());
        json.writeNumberField("p999", snapshot.get999thPercentile());
    }

    private static void writeMeteredFields(Metered metered, JsonGenerator json) throws IOException {
        json.writeNumberField("count", metered.count());
        json.writeNumberField("mean", metered.meanRate());
        json.writeNumberField("m1", metered.oneMinuteRate());
    }

    private static String sanitize(MetricName metricName) {
        return SIMPLE_NAMES.matcher(metricName.getGroup() + "." + metricName.getName()).replaceAll("_");
    }

    static final class Processor
    implements MetricProcessor<Context> {
        private final boolean clear;

        public Processor(boolean clear) {
            this.clear = clear;
        }

        public void processHistogram(MetricName name, Histogram histogram, Context context) throws Exception {
            JsonGenerator json = context.json;
            json.writeStartObject();
            json.writeNumberField("count", histogram.count());
            JsonMetricsGenerator.writeSummarizable((Summarizable)histogram, json);
            JsonMetricsGenerator.writeSampling((Sampling)histogram, json);
            if (context.showFullSamples) {
                json.writeObjectField("values", (Object)histogram.getSnapshot().getValues());
            }
            if (this.clear) {
                histogram.clear();
            }
            json.writeEndObject();
        }

        public void processCounter(MetricName name, Counter counter, Context context) throws Exception {
            JsonGenerator json = context.json;
            json.writeNumber(counter.count());
        }

        public void processGauge(MetricName name, Gauge<?> gauge, Context context) throws Exception {
            JsonGenerator json = context.json;
            Object gaugeValue = JsonMetricsGenerator.evaluateGauge(gauge);
            if (gaugeValue != null) {
                json.writeObject(gaugeValue);
            } else {
                json.writeNull();
            }
        }

        public void processMeter(MetricName name, Metered meter, Context context) throws Exception {
            JsonGenerator json = context.json;
            json.writeStartObject();
            JsonMetricsGenerator.writeMeteredFields(meter, json);
            json.writeEndObject();
        }

        public void processTimer(MetricName name, Timer timer, Context context) throws Exception {
            JsonGenerator json = context.json;
            json.writeStartObject();
            json.writeFieldName("duration");
            json.writeStartObject();
            json.writeStringField("unit", timer.durationUnit().toString().toLowerCase());
            JsonMetricsGenerator.writeSummarizable((Summarizable)timer, json);
            JsonMetricsGenerator.writeSampling((Sampling)timer, json);
            if (context.showFullSamples) {
                json.writeObjectField("values", (Object)timer.getSnapshot().getValues());
            }
            json.writeEndObject();
            json.writeFieldName("rate");
            json.writeStartObject();
            JsonMetricsGenerator.writeMeteredFields((Metered)timer, json);
            json.writeEndObject();
            json.writeEndObject();
            if (this.clear) {
                timer.clear();
            }
        }
    }

    static final class Context {
        final boolean showFullSamples;
        final JsonGenerator json;

        Context(JsonGenerator json, boolean showFullSamples) {
            this.json = json;
            this.showFullSamples = showFullSamples;
        }
    }
}

