/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.api.agent;

import com.google.common.base.Preconditions;
import com.wavefront.api.agent.AgentConfiguration;
import java.util.UUID;

public class SshTargetDTO {
    public UUID id;
    public String host;
    public int port = 22;
    public String hostKey;
    public String user;
    public String publicKey;

    public void validate(AgentConfiguration config) {
        Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null for host");
        Preconditions.checkNotNull((Object)this.host, (Object)"host cannot be null");
        Preconditions.checkState((this.port > 0 ? 1 : 0) != 0, (Object)"port must be greater than 0");
        Preconditions.checkNotNull((Object)this.publicKey, (Object)"publicKey cannot be null");
        if (this.user == null) {
            this.user = config.defaultUsername;
        }
        if (this.publicKey == null) {
            this.publicKey = config.defaultPublicKey;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshTargetDTO sshTargetDTO = (SshTargetDTO)o;
        if (this.port != sshTargetDTO.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(sshTargetDTO.host) : sshTargetDTO.host != null) {
            return false;
        }
        if (this.hostKey != null ? !this.hostKey.equals(sshTargetDTO.hostKey) : sshTargetDTO.hostKey != null) {
            return false;
        }
        if (!this.id.equals(sshTargetDTO.id)) {
            return false;
        }
        if (this.publicKey != null ? !this.publicKey.equals(sshTargetDTO.publicKey) : sshTargetDTO.publicKey != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(sshTargetDTO.user) : sshTargetDTO.user != null);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.hostKey != null ? this.hostKey.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        return result;
    }
}

