/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.wavefront.api.agent.AgentConfiguration;
import com.wavefront.api.agent.ShellOutputDTO;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.GZIP;

@Path(value="/")
public interface WavefrontAPI {
    @GET
    @Path(value="daemon/{agentId}/config")
    @Produces(value={"application/json"})
    public AgentConfiguration getConfig(@PathParam(value="agentId") UUID var1, @QueryParam(value="hostname") String var2, @QueryParam(value="currentMillis") Long var3, @QueryParam(value="bytesLeftForBuffer") Long var4, @QueryParam(value="bytesPerMinuteForBuffer") Long var5, @QueryParam(value="currentQueueSize") Long var6, @QueryParam(value="token") String var7, @QueryParam(value="version") String var8);

    @POST
    @Path(value="daemon/{sshDaemonId}/checkin")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AgentConfiguration checkin(@PathParam(value="sshDaemonId") UUID var1, @QueryParam(value="hostname") String var2, @QueryParam(value="token") String var3, @QueryParam(value="version") String var4, @QueryParam(value="currentMillis") Long var5, @QueryParam(value="local") Boolean var6, @GZIP JsonNode var7, @QueryParam(value="push") Boolean var8, @QueryParam(value="ephemeral") Boolean var9);

    @POST
    @Consumes(value={"text/plain"})
    @Path(value="daemon/{agentId}/pushdata/{workUnitId}")
    public Response postPushData(@PathParam(value="agentId") UUID var1, @PathParam(value="workUnitId") UUID var2, @Deprecated @QueryParam(value="currentMillis") Long var3, @QueryParam(value="format") String var4, @GZIP String var5);

    @POST
    @Path(value="daemon/{agentId}/error")
    public void agentError(@PathParam(value="agentId") UUID var1, @FormParam(value="details") String var2);

    @POST
    @Path(value="daemon/{agentId}/config/processed")
    public void agentConfigProcessed(@PathParam(value="agentId") UUID var1);

    @POST
    @Consumes(value={"application/json"})
    @Path(value="daemon/{agentId}/workunit/{workUnitId}/{hostId}")
    public Response postWorkUnitResult(@PathParam(value="agentId") UUID var1, @PathParam(value="workUnitId") UUID var2, @PathParam(value="hostId") UUID var3, @GZIP @Valid ShellOutputDTO var4);

    @POST
    @Path(value="daemon/{agentId}/host/{hostId}/fail")
    public void hostConnectionFailed(@PathParam(value="agentId") UUID var1, @PathParam(value="hostId") UUID var2, @FormParam(value="details") String var3);

    @POST
    @Path(value="daemon/{agentId}/host/{hostId}/connect")
    public void hostConnectionEstablished(@PathParam(value="agentId") UUID var1, @PathParam(value="hostId") UUID var2);

    @POST
    @Path(value="daemon/{agentId}/host/{hostId}/auth")
    public void hostAuthenticated(@PathParam(value="agentId") UUID var1, @PathParam(value="hostId") UUID var2);

    @DELETE
    @Path(value="v2/source/{id}/tag/{tagValue}")
    @Produces(value={"application/json"})
    public Response removeTag(@PathParam(value="id") String var1, @PathParam(value="tagValue") String var2);

    @DELETE
    @Path(value="v2/source/{id}/description")
    @Produces(value={"application/json"})
    public Response removeDescription(@PathParam(value="id") String var1);

    @POST
    @Path(value="v2/source/{id}/tag")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setTags(@PathParam(value="id") String var1, List<String> var2);

    @POST
    @Path(value="v2/source/{id}/description")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setDescription(@PathParam(value="id") String var1, String var2);
}

