/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.google.common.collect.ImmutableMap;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.VirtualMachineMetrics;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public abstract class MetricsToTimeseries {
    private static final Pattern SIMPLE_NAMES = Pattern.compile("[^a-zA-Z0-9_.\\-~]");

    public static Map<String, Double> explodeSummarizable(Summarizable metric) {
        return ImmutableMap.builder().put((Object)"min", (Object)metric.min()).put((Object)"max", (Object)metric.max()).put((Object)"mean", (Object)metric.mean()).put((Object)"sum", (Object)metric.sum()).put((Object)"stddev", (Object)metric.stdDev()).build();
    }

    public static Map<String, Double> explodeSampling(Sampling sampling) {
        return ImmutableMap.builder().put((Object)"median", (Object)sampling.getSnapshot().getMedian()).put((Object)"p75", (Object)sampling.getSnapshot().get75thPercentile()).put((Object)"p95", (Object)sampling.getSnapshot().get95thPercentile()).put((Object)"p99", (Object)sampling.getSnapshot().get99thPercentile()).put((Object)"p999", (Object)sampling.getSnapshot().get999thPercentile()).build();
    }

    public static Map<String, Double> explodeMetered(Metered metered) {
        return ImmutableMap.builder().put((Object)"count", (Object)new Long(metered.count()).doubleValue()).put((Object)"mean", (Object)metered.meanRate()).put((Object)"m1", (Object)metered.oneMinuteRate()).put((Object)"m5", (Object)metered.fiveMinuteRate()).put((Object)"m15", (Object)metered.fifteenMinuteRate()).build();
    }

    public static Map<String, Supplier<Double>> memoryMetrics(VirtualMachineMetrics vm) {
        return ImmutableMap.builder().put((Object)"totalInit", () -> ((VirtualMachineMetrics)vm).totalInit()).put((Object)"totalUsed", () -> ((VirtualMachineMetrics)vm).totalUsed()).put((Object)"totalMax", () -> ((VirtualMachineMetrics)vm).totalMax()).put((Object)"totalCommitted", () -> ((VirtualMachineMetrics)vm).totalCommitted()).put((Object)"heapInit", () -> ((VirtualMachineMetrics)vm).heapInit()).put((Object)"heapUsed", () -> ((VirtualMachineMetrics)vm).heapUsed()).put((Object)"heapMax", () -> ((VirtualMachineMetrics)vm).heapMax()).put((Object)"heapCommitted", () -> ((VirtualMachineMetrics)vm).heapCommitted()).put((Object)"heap_usage", () -> ((VirtualMachineMetrics)vm).heapUsage()).put((Object)"non_heap_usage", () -> ((VirtualMachineMetrics)vm).nonHeapUsage()).build();
    }

    public static Map<String, Supplier<Double>> memoryPoolsMetrics(VirtualMachineMetrics vm) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry pool : vm.memoryPoolUsage().entrySet()) {
            builder.put(pool.getKey(), pool::getValue);
        }
        return builder.build();
    }

    public static Map<String, Supplier<Double>> buffersMetrics(VirtualMachineMetrics.BufferPoolStats bps) {
        return ImmutableMap.builder().put((Object)"count", () -> bps.getCount()).put((Object)"memoryUsed", () -> bps.getMemoryUsed()).put((Object)"totalCapacity", () -> bps.getTotalCapacity()).build();
    }

    public static Map<String, Supplier<Double>> vmMetrics(VirtualMachineMetrics vm) {
        return ImmutableMap.builder().put((Object)"daemon_thread_count", () -> vm.daemonThreadCount()).put((Object)"thread_count", () -> vm.threadCount()).put((Object)"uptime", () -> vm.uptime()).put((Object)"fd_usage", () -> ((VirtualMachineMetrics)vm).fileDescriptorUsage()).build();
    }

    public static Map<String, Supplier<Double>> threadStateMetrics(VirtualMachineMetrics vm) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : vm.threadStatePercentages().entrySet()) {
            builder.put((Object)((Thread.State)((Object)entry.getKey())).toString().toLowerCase(), entry::getValue);
        }
        return builder.build();
    }

    public static Map<String, Supplier<Double>> gcMetrics(VirtualMachineMetrics.GarbageCollectorStats gcs) {
        return ImmutableMap.builder().put((Object)"runs", () -> gcs.getRuns()).put((Object)"time", () -> gcs.getTime(TimeUnit.MILLISECONDS)).build();
    }

    public static String sanitize(String name) {
        return SIMPLE_NAMES.matcher(name).replaceAll("_");
    }

    public static String sanitize(MetricName metricName) {
        return MetricsToTimeseries.sanitize(metricName.getGroup() + "." + metricName.getName());
    }
}

