/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.metrics;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.tdunning.math.stats.Centroid;
import com.wavefront.common.MetricsToTimeseries;
import com.wavefront.common.Pair;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.metrics.MetricTranslator;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.core.WavefrontHistogram;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public abstract class JsonMetricsGenerator {
    private static final JsonFactory factory = new JsonFactory();
    private static final Clock clock = Clock.defaultClock();
    private static final VirtualMachineMetrics vm = VirtualMachineMetrics.getInstance();

    public static void generateJsonMetrics(OutputStream outputStream, MetricsRegistry registry, boolean includeVMMetrics, boolean includeBuildMetrics, boolean clearMetrics, MetricTranslator metricTranslator) throws IOException {
        JsonGenerator json = factory.createGenerator(outputStream, JsonEncoding.UTF8);
        JsonMetricsGenerator.writeJson(json, registry, includeVMMetrics, includeBuildMetrics, clearMetrics, null, metricTranslator);
    }

    public static JsonNode generateJsonMetrics(MetricsRegistry registry, boolean includeVMMetrics, boolean includeBuildMetrics, boolean clearMetrics) throws IOException {
        return JsonMetricsGenerator.generateJsonMetrics(registry, includeVMMetrics, includeBuildMetrics, clearMetrics, null, null);
    }

    public static JsonNode generateJsonMetrics(MetricsRegistry registry, boolean includeVMMetrics, boolean includeBuildMetrics, boolean clearMetrics, @Nullable Map<String, String> pointTags, @Nullable MetricTranslator metricTranslator) throws IOException {
        TokenBuffer t = new TokenBuffer((ObjectCodec)new ObjectMapper());
        JsonMetricsGenerator.writeJson((JsonGenerator)t, registry, includeVMMetrics, includeBuildMetrics, clearMetrics, pointTags, metricTranslator);
        JsonParser parser = t.asParser();
        return (JsonNode)parser.readValueAsTree();
    }

    public static void writeJson(JsonGenerator json, MetricsRegistry registry, boolean includeVMMetrics, boolean includeBuildMetrics, boolean clearMetrics) throws IOException {
        JsonMetricsGenerator.writeJson(json, registry, includeVMMetrics, includeBuildMetrics, clearMetrics, null, null);
    }

    public static void writeJson(JsonGenerator json, MetricsRegistry registry, boolean includeVMMetrics, boolean includeBuildMetrics, boolean clearMetrics, @Nullable Map<String, String> pointTags, @Nullable MetricTranslator metricTranslator) throws IOException {
        json.writeStartObject();
        if (includeVMMetrics) {
            JsonMetricsGenerator.writeVmMetrics(json, pointTags);
        }
        if (includeBuildMetrics) {
            try {
                JsonMetricsGenerator.writeBuildMetrics(ResourceBundle.getBundle("build"), json, pointTags);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        JsonMetricsGenerator.writeRegularMetrics(new Processor(clearMetrics), json, registry, false, pointTags, metricTranslator);
        json.writeEndObject();
        json.close();
    }

    private static void writeBuildMetrics(ResourceBundle props, JsonGenerator json, Map<String, String> pointTags) throws IOException {
        json.writeFieldName("build");
        if (pointTags != null) {
            json.writeStartObject();
            JsonMetricsGenerator.writeTags(json, pointTags);
            json.writeFieldName("value");
        }
        json.writeStartObject();
        if (props.containsKey("build.version")) {
            int version = JsonMetricsGenerator.extractVersion(props.getString("build.version"));
            if (version != 0) {
                json.writeNumberField("version", version);
            }
            json.writeStringField("version_raw", props.getString("build.version"));
        }
        if (props.containsKey("build.commit")) {
            json.writeStringField("commit", props.getString("build.commit"));
        }
        if (props.containsKey("build.hostname")) {
            json.writeStringField("build_host", props.getString("build.hostname"));
        }
        if (props.containsKey("maven.build.timestamp")) {
            if (StringUtils.isNumeric((String)props.getString("maven.build.timestamp"))) {
                json.writeNumberField("timestamp", Long.valueOf(props.getString("maven.build.timestamp")).longValue());
            }
            json.writeStringField("timestamp_raw", props.getString("maven.build.timestamp"));
        }
        json.writeEndObject();
        if (pointTags != null) {
            json.writeEndObject();
        }
    }

    static int extractVersion(String versionStr) {
        int version = 0;
        String[] components = versionStr.split("\\.");
        for (int i = 0; i < Math.min(3, components.length); ++i) {
            String component = components[i];
            if (StringUtils.isNotBlank((String)component) && StringUtils.isNumeric((String)component)) {
                version *= 1000;
                version += Integer.valueOf(component).intValue();
                continue;
            }
            version = 0;
            break;
        }
        if (components.length == 2) {
            version *= 1000;
        } else if (components.length == 1) {
            version *= 1000000;
        }
        return version;
    }

    private static void mergeMapIntoJson(JsonGenerator jsonGenerator, Map<String, Double> metrics) throws IOException {
        for (Map.Entry<String, Double> entry : metrics.entrySet()) {
            jsonGenerator.writeNumberField(entry.getKey(), entry.getValue().doubleValue());
        }
    }

    private static void mergeSupplierMapIntoJson(JsonGenerator jsonGenerator, Map<String, Supplier<Double>> metrics) throws IOException {
        for (Map.Entry<String, Supplier<Double>> entry : metrics.entrySet()) {
            jsonGenerator.writeNumberField(entry.getKey(), entry.getValue().get().doubleValue());
        }
    }

    private static void writeVmMetrics(JsonGenerator json, @Nullable Map<String, String> pointTags) throws IOException {
        json.writeFieldName("jvm");
        if (pointTags != null) {
            json.writeStartObject();
            JsonMetricsGenerator.writeTags(json, pointTags);
            json.writeFieldName("value");
        }
        json.writeStartObject();
        json.writeFieldName("vm");
        json.writeStartObject();
        json.writeStringField("name", vm.name());
        json.writeStringField("version", vm.version());
        json.writeEndObject();
        json.writeFieldName("memory");
        json.writeStartObject();
        JsonMetricsGenerator.mergeSupplierMapIntoJson(json, MetricsToTimeseries.memoryMetrics(() -> vm));
        json.writeFieldName("memory_pool_usages");
        json.writeStartObject();
        JsonMetricsGenerator.mergeSupplierMapIntoJson(json, MetricsToTimeseries.memoryPoolsMetrics(() -> vm));
        json.writeEndObject();
        json.writeEndObject();
        Map bufferPoolStats = vm.getBufferPoolStats();
        if (!bufferPoolStats.isEmpty()) {
            json.writeFieldName("buffers");
            json.writeStartObject();
            json.writeFieldName("direct");
            json.writeStartObject();
            JsonMetricsGenerator.mergeSupplierMapIntoJson(json, MetricsToTimeseries.buffersMetrics(() -> (VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("direct")));
            json.writeEndObject();
            json.writeFieldName("mapped");
            json.writeStartObject();
            JsonMetricsGenerator.mergeSupplierMapIntoJson(json, MetricsToTimeseries.buffersMetrics(() -> (VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("mapped")));
            json.writeEndObject();
            json.writeEndObject();
        }
        JsonMetricsGenerator.mergeSupplierMapIntoJson(json, MetricsToTimeseries.vmMetrics(() -> vm));
        json.writeNumberField("current_time", clock.time());
        json.writeFieldName("thread-states");
        json.writeStartObject();
        JsonMetricsGenerator.mergeSupplierMapIntoJson(json, MetricsToTimeseries.threadStateMetrics(() -> vm));
        json.writeEndObject();
        json.writeFieldName("garbage-collectors");
        json.writeStartObject();
        for (Map.Entry entry : vm.garbageCollectors().entrySet()) {
            json.writeFieldName((String)entry.getKey());
            json.writeStartObject();
            JsonMetricsGenerator.mergeSupplierMapIntoJson(json, MetricsToTimeseries.gcMetrics(() -> (VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()));
            json.writeEndObject();
        }
        json.writeEndObject();
        json.writeEndObject();
        if (pointTags != null) {
            json.writeEndObject();
        }
    }

    private static void writeTags(JsonGenerator json, Map<String, String> pointTags) throws IOException {
        Validate.notNull(pointTags, (String)"pointTags argument can't be null!");
        json.writeFieldName("tags");
        json.writeStartObject();
        for (Map.Entry<String, String> tagEntry : pointTags.entrySet()) {
            json.writeStringField(tagEntry.getKey(), tagEntry.getValue());
        }
        json.writeEndObject();
    }

    public static void writeRegularMetrics(Processor processor, JsonGenerator json, MetricsRegistry registry, boolean showFullSamples) throws IOException {
        JsonMetricsGenerator.writeRegularMetrics(processor, json, registry, showFullSamples, null);
    }

    public static void writeRegularMetrics(Processor processor, JsonGenerator json, MetricsRegistry registry, boolean showFullSamples, @Nullable Map<String, String> pointTags) throws IOException {
        JsonMetricsGenerator.writeRegularMetrics(processor, json, registry, showFullSamples, pointTags, null);
    }

    public static void writeRegularMetrics(Processor processor, JsonGenerator json, MetricsRegistry registry, boolean showFullSamples, @Nullable Map<String, String> pointTags, @Nullable MetricTranslator metricTranslator) throws IOException {
        for (Map.Entry entry : registry.groupedMetrics().entrySet()) {
            for (Map.Entry subEntry : ((SortedMap)entry.getValue()).entrySet()) {
                MetricName key = (MetricName)subEntry.getKey();
                Metric value = (Metric)subEntry.getValue();
                if (metricTranslator != null) {
                    Pair pair = (Pair)metricTranslator.apply(Pair.of(key, value));
                    if (pair == null) continue;
                    key = (MetricName)pair._1;
                    value = (Metric)pair._2;
                }
                boolean closeObjectRequired = false;
                if (key instanceof TaggedMetricName || pointTags != null) {
                    closeObjectRequired = true;
                    json.writeFieldName(MetricsToTimeseries.sanitize(key) + "$" + subEntry.hashCode());
                    json.writeStartObject();
                    json.writeFieldName("tags");
                    json.writeStartObject();
                    HashMap<String, String> tags = new HashMap<String, String>();
                    if (pointTags != null) {
                        tags.putAll(pointTags);
                    }
                    if (key instanceof TaggedMetricName) {
                        tags.putAll(((TaggedMetricName)key).getTags());
                    }
                    for (Map.Entry tagEntry : tags.entrySet()) {
                        json.writeStringField((String)tagEntry.getKey(), (String)tagEntry.getValue());
                    }
                    json.writeEndObject();
                    json.writeFieldName("value");
                } else {
                    json.writeFieldName(MetricsToTimeseries.sanitize(key));
                }
                try {
                    value.processWith((MetricProcessor)processor, key, (Object)new Context(json, showFullSamples));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!closeObjectRequired) continue;
                json.writeEndObject();
            }
        }
    }

    private static Object evaluateGauge(Gauge<?> gauge) {
        try {
            return gauge.value();
        }
        catch (RuntimeException e) {
            return "error reading gauge: " + e.getMessage();
        }
    }

    private static void writeSummarizable(Summarizable metric, JsonGenerator json) throws IOException {
        for (Map.Entry<String, Double> entry : MetricsToTimeseries.explodeSummarizable(metric).entrySet()) {
            json.writeNumberField(entry.getKey(), entry.getValue().doubleValue());
        }
    }

    private static void writeSampling(Sampling metric, JsonGenerator json) throws IOException {
        for (Map.Entry<String, Double> entry : MetricsToTimeseries.explodeSampling(metric).entrySet()) {
            json.writeNumberField(entry.getKey(), entry.getValue().doubleValue());
        }
    }

    private static void writeMeteredFields(Metered metered, JsonGenerator json) throws IOException {
        for (Map.Entry<String, Double> entry : MetricsToTimeseries.explodeMetered(metered).entrySet()) {
            json.writeNumberField(entry.getKey(), entry.getValue().doubleValue());
        }
    }

    static final class Processor
    implements MetricProcessor<Context> {
        private final boolean clear;

        public Processor(boolean clear) {
            this.clear = clear;
        }

        private void internalProcessYammerHistogram(Histogram histogram, Context context) throws Exception {
            JsonGenerator json = context.json;
            json.writeStartObject();
            json.writeNumberField("count", histogram.count());
            JsonMetricsGenerator.writeSummarizable((Summarizable)histogram, json);
            JsonMetricsGenerator.writeSampling((Sampling)histogram, json);
            if (context.showFullSamples) {
                json.writeObjectField("values", (Object)histogram.getSnapshot().getValues());
            }
            if (this.clear) {
                histogram.clear();
            }
            json.writeEndObject();
        }

        private void internalProcessWavefrontHistogram(WavefrontHistogram hist, Context context) throws Exception {
            JsonGenerator json = context.json;
            json.writeStartObject();
            json.writeArrayFieldStart("bins");
            for (WavefrontHistogram.MinuteBin bin : hist.bins(this.clear)) {
                Collection centroids = bin.getDist().centroids();
                json.writeStartObject();
                json.writeNumberField("count", bin.getDist().size());
                json.writeNumberField("startMillis", bin.getMinMillis());
                json.writeNumberField("durationMillis", 60000);
                json.writeArrayFieldStart("means");
                for (Centroid c : centroids) {
                    json.writeNumber(c.mean());
                }
                json.writeEndArray();
                json.writeArrayFieldStart("counts");
                for (Centroid c : centroids) {
                    json.writeNumber(c.count());
                }
                json.writeEndArray();
                json.writeEndObject();
            }
            json.writeEndArray();
            json.writeEndObject();
        }

        public void processHistogram(MetricName name, Histogram histogram, Context context) throws Exception {
            if (histogram instanceof WavefrontHistogram) {
                this.internalProcessWavefrontHistogram((WavefrontHistogram)histogram, context);
            } else {
                this.internalProcessYammerHistogram(histogram, context);
            }
        }

        public void processCounter(MetricName name, Counter counter, Context context) throws Exception {
            JsonGenerator json = context.json;
            json.writeNumber(counter.count());
        }

        public void processGauge(MetricName name, Gauge<?> gauge, Context context) throws Exception {
            JsonGenerator json = context.json;
            Object gaugeValue = JsonMetricsGenerator.evaluateGauge(gauge);
            if (gaugeValue != null) {
                json.writeObject(gaugeValue);
            } else {
                json.writeNull();
            }
        }

        public void processMeter(MetricName name, Metered meter, Context context) throws Exception {
            JsonGenerator json = context.json;
            json.writeStartObject();
            JsonMetricsGenerator.writeMeteredFields(meter, json);
            json.writeEndObject();
        }

        public void processTimer(MetricName name, Timer timer, Context context) throws Exception {
            JsonGenerator json = context.json;
            json.writeStartObject();
            json.writeFieldName("duration");
            json.writeStartObject();
            json.writeStringField("unit", timer.durationUnit().toString().toLowerCase());
            JsonMetricsGenerator.writeSummarizable((Summarizable)timer, json);
            JsonMetricsGenerator.writeSampling((Sampling)timer, json);
            if (context.showFullSamples) {
                json.writeObjectField("values", (Object)timer.getSnapshot().getValues());
            }
            json.writeEndObject();
            json.writeFieldName("rate");
            json.writeStartObject();
            JsonMetricsGenerator.writeMeteredFields((Metered)timer, json);
            json.writeEndObject();
            json.writeEndObject();
            if (this.clear) {
                timer.clear();
            }
        }
    }

    static final class Context {
        final boolean showFullSamples;
        final JsonGenerator json;

        Context(JsonGenerator json, boolean showFullSamples) {
            this.json = json;
            this.showFullSamples = showFullSamples;
        }
    }
}

