/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.common.Clock;
import com.wavefront.ingester.AbstractIngesterFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.Token;
import wavefront.report.ReportPoint;

public class ReportPointIngesterFormatter
extends AbstractIngesterFormatter<ReportPoint> {
    private ReportPointIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<ReportPoint> newBuilder() {
        return new ReportPointIngesterFormatBuilder();
    }

    @Override
    public ReportPoint drive(String input, String defaultHostName, String customerId, @Nullable List<String> customSourceTags) {
        double v;
        Queue<Token> queue = this.getQueue(input);
        ReportPoint point = new ReportPoint();
        point.setTable(customerId);
        point.setTimestamp(Clock.now());
        AbstractIngesterFormatter.ReportPointWrapper wrapper = new AbstractIngesterFormatter.ReportPointWrapper(point);
        try {
            for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
                element.consume(queue, wrapper);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        if (!queue.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        if ((point.getMetric().startsWith("\u2206") || point.getMetric().startsWith("\u0394")) && point.getValue() instanceof Number && (v = ((Number)point.getValue()).doubleValue()) <= 0.0) {
            throw new RuntimeException("Delta metrics cannot be non-positive: " + input);
        }
        String host = null;
        Map<String, String> annotations = point.getAnnotations();
        if (annotations != null) {
            host = annotations.remove("source");
            if (host == null) {
                host = annotations.remove("host");
            } else if (annotations.containsKey("host")) {
                annotations.put("_host", annotations.remove("host"));
            }
            if (annotations.containsKey("tag")) {
                annotations.put("_tag", annotations.remove("tag"));
            }
            if (host == null && customSourceTags != null) {
                String tag;
                Iterator<String> iterator = customSourceTags.iterator();
                while (iterator.hasNext() && (host = annotations.get(tag = iterator.next())) == null) {
                }
            }
        }
        if (host == null) {
            host = defaultHostName;
        }
        point.setHost(host);
        return ReportPoint.newBuilder(point).build();
    }

    public static class ReportPointIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportPoint> {
        public ReportPointIngesterFormatter build() {
            return new ReportPointIngesterFormatter(this.elements);
        }
    }
}

