/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sunnylabs.report.Histogram;
import sunnylabs.report.HistogramType;
import sunnylabs.report.ReportPoint;

public class JsonMetricsParser {
    private static final Pattern SIMPLE_NAMES = Pattern.compile("[^a-zA-Z0-9_.-]");
    private static final Pattern TAGGED_METRIC = Pattern.compile("(.*)\\$[0-9-]+");

    public static void report(String table, String path, JsonNode node, List<ReportPoint> points, String host, long timestamp) {
        JsonMetricsParser.report(table, path, node, points, host, timestamp, Collections.emptyMap());
    }

    public static void report(String table, String path, JsonNode node, List<ReportPoint> points, String host, long timestamp, Map<String, String> tags) {
        ArrayList fields = Lists.newArrayList((Iterator)node.fields());
        if (fields.size() == 2) {
            JsonNode valueNode = null;
            JsonNode tagsNode = null;
            for (Map.Entry next : fields) {
                if (((String)next.getKey()).equals("value")) {
                    valueNode = (JsonNode)next.getValue();
                    continue;
                }
                if (!((String)next.getKey()).equals("tags")) continue;
                tagsNode = (JsonNode)next.getValue();
            }
            if (valueNode != null && tagsNode != null) {
                HashMap combinedTags = Maps.newHashMap(tags);
                combinedTags.putAll(JsonMetricsParser.makeTags(tagsNode));
                JsonMetricsParser.processValueNode(valueNode, table, path, host, timestamp, points, combinedTags);
                return;
            }
        }
        for (Map.Entry next : fields) {
            Matcher taggedMetricMatcher = TAGGED_METRIC.matcher((CharSequence)next.getKey());
            String key = taggedMetricMatcher.matches() ? SIMPLE_NAMES.matcher(taggedMetricMatcher.group(1)).replaceAll("_") : SIMPLE_NAMES.matcher((CharSequence)next.getKey()).replaceAll("_");
            String metric = path == null ? key : path + "." + key;
            JsonNode value = (JsonNode)next.getValue();
            JsonMetricsParser.processValueNode(value, table, metric, host, timestamp, points, tags);
        }
    }

    public static void processValueNode(JsonNode value, String table, String metric, String host, long timestamp, List<ReportPoint> points, Map<String, String> tags) {
        if (value.isNumber()) {
            if (value.isLong()) {
                points.add(JsonMetricsParser.makePoint(table, metric, host, value.longValue(), timestamp, tags));
            } else {
                points.add(JsonMetricsParser.makePoint(table, metric, host, value.doubleValue(), timestamp, tags));
            }
        } else if (value.isTextual()) {
            points.add(JsonMetricsParser.makePoint(table, metric, host, value.textValue(), timestamp, tags));
        } else if (value.isObject()) {
            if (value.has("bins")) {
                Iterator binIt = ((ArrayNode)value.get("bins")).elements();
                while (binIt.hasNext()) {
                    JsonNode bin = (JsonNode)binIt.next();
                    ArrayList counts = Lists.newArrayList();
                    bin.get("counts").elements().forEachRemaining(v -> counts.add(v.intValue()));
                    ArrayList means = Lists.newArrayList();
                    bin.get("means").elements().forEachRemaining(v -> means.add(v.doubleValue()));
                    points.add(JsonMetricsParser.makeHistogramPoint(table, metric, host, tags, bin.get("startMillis").longValue(), bin.get("durationMillis").intValue(), means, counts));
                }
            } else {
                JsonMetricsParser.report(table, metric, value, points, host, timestamp, tags);
            }
        } else if (value.isBoolean()) {
            points.add(JsonMetricsParser.makePoint(table, metric, host, value.booleanValue() ? 1.0 : 0.0, timestamp, tags));
        }
    }

    public static ReportPoint makeHistogramPoint(String customer, String metric, String host, Map<String, String> annotations, long startMillis, int durationMillis, List<Double> bins, List<Integer> counts) {
        Histogram histogram = Histogram.newBuilder().setType(HistogramType.TDIGEST).setDuration(durationMillis).setCounts(counts).setBins(bins).build();
        return JsonMetricsParser.makePoint(customer, metric, host, startMillis, annotations).setValue(histogram).build();
    }

    public static ReportPoint makePoint(String table, String metric, String host, String value, long timestamp) {
        return JsonMetricsParser.makePoint(table, metric, host, value, timestamp, Collections.emptyMap());
    }

    public static ReportPoint makePoint(String table, String metric, String host, String value, long timestamp, Map<String, String> annotations) {
        ReportPoint.Builder builder = JsonMetricsParser.makePoint(table, metric, host, timestamp, annotations);
        return builder.setValue(value).build();
    }

    public static ReportPoint makePoint(String table, String metric, String host, long value, long timestamp) {
        return JsonMetricsParser.makePoint(table, metric, host, value, timestamp, Collections.emptyMap());
    }

    public static ReportPoint makePoint(String table, String metric, String host, long value, long timestamp, Map<String, String> annotations) {
        ReportPoint.Builder builder = JsonMetricsParser.makePoint(table, metric, host, timestamp, annotations);
        return builder.setValue(value).build();
    }

    public static ReportPoint makePoint(String table, String metric, String host, double value, long timestamp) {
        return JsonMetricsParser.makePoint(table, metric, host, value, timestamp, Collections.emptyMap());
    }

    public static ReportPoint makePoint(String table, String metric, String host, double value, long timestamp, Map<String, String> annotations) {
        ReportPoint.Builder builder = JsonMetricsParser.makePoint(table, metric, host, timestamp, annotations);
        return builder.setValue(value).build();
    }

    private static ReportPoint.Builder makePoint(String table, String metric, String host, long timestamp, Map<String, String> annotations) {
        return ReportPoint.newBuilder().setAnnotations(annotations).setMetric(metric).setTable(table).setTimestamp(timestamp).setHost(host);
    }

    public static Map<String, String> makeTags(JsonNode tags) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (tags.isObject()) {
            Iterator fields = tags.fields();
            while (fields.hasNext()) {
                Map.Entry next = (Map.Entry)fields.next();
                String key = SIMPLE_NAMES.matcher((CharSequence)next.getKey()).replaceAll("_");
                JsonNode value = (JsonNode)next.getValue();
                if (value.isBoolean()) {
                    builder.put((Object)key, (Object)String.valueOf(value.booleanValue()));
                    continue;
                }
                if (value.isNumber()) {
                    if (value.isLong()) {
                        builder.put((Object)key, (Object)String.valueOf(value.asLong()));
                        continue;
                    }
                    builder.put((Object)key, (Object)String.valueOf(value.asDouble()));
                    continue;
                }
                if (!value.isTextual()) continue;
                builder.put((Object)key, (Object)value.asText());
            }
        }
        return builder.build();
    }
}

