/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.metrics.ExpectedAgentMetric;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import java.net.BindException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class StreamIngester
implements Runnable {
    protected static final Logger logger = Logger.getLogger(StreamIngester.class.getName());
    private Counter activeListeners;
    private Counter bindErrors;
    private final ChannelHandler commandHandler;
    private final int listeningPort;
    private final FrameDecoderFactory frameDecoderFactory;
    @Nullable
    protected Map<ChannelOption<?>, ?> parentChannelOptions;
    @Nullable
    protected Map<ChannelOption<?>, ?> childChannelOptions;

    public StreamIngester(FrameDecoderFactory frameDecoderFactory, ChannelHandler commandHandler, int port) {
        this.activeListeners = Metrics.newCounter((MetricName)ExpectedAgentMetric.ACTIVE_LISTENERS.metricName);
        this.bindErrors = Metrics.newCounter((MetricName)ExpectedAgentMetric.LISTENERS_BIND_ERRORS.metricName);
        this.listeningPort = port;
        this.commandHandler = commandHandler;
        this.frameDecoderFactory = frameDecoderFactory;
    }

    public StreamIngester withParentChannelOptions(Map<ChannelOption<?>, ?> parentChannelOptions) {
        this.parentChannelOptions = parentChannelOptions;
        return this;
    }

    public StreamIngester withChildChannelOptions(Map<ChannelOption<?>, ?> childChannelOptions) {
        this.childChannelOptions = childChannelOptions;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Class<EpollServerSocketChannel> socketChannelClass;
        EpollEventLoopGroup childGroup;
        EpollEventLoopGroup parentGroup;
        this.activeListeners.inc();
        ServerBootstrap b = new ServerBootstrap();
        if (Epoll.isAvailable()) {
            logger.fine("Using native socket transport for port " + this.listeningPort);
            parentGroup = new EpollEventLoopGroup(1);
            childGroup = new EpollEventLoopGroup();
            socketChannelClass = EpollServerSocketChannel.class;
        } else {
            logger.fine("Using NIO socket transport for port " + this.listeningPort);
            parentGroup = new NioEventLoopGroup(1);
            childGroup = new NioEventLoopGroup();
            socketChannelClass = NioServerSocketChannel.class;
        }
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)parentGroup, (EventLoopGroup)childGroup).channel(socketChannelClass)).option(ChannelOption.SO_BACKLOG, (Object)1024)).localAddress(this.listeningPort)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("frame decoder", (ChannelHandler)StreamIngester.this.frameDecoderFactory.getDecoder());
                    pipeline.addLast("byte array decoder", (ChannelHandler)new ByteArrayDecoder());
                    pipeline.addLast(new ChannelHandler[]{StreamIngester.this.commandHandler});
                }
            });
            if (this.parentChannelOptions != null) {
                for (Map.Entry<ChannelOption<?>, ?> entry : this.parentChannelOptions.entrySet()) {
                    b.option(entry.getKey(), entry.getValue());
                }
            }
            if (this.childChannelOptions != null) {
                for (Map.Entry<ChannelOption<?>, ?> entry : this.childChannelOptions.entrySet()) {
                    b.childOption(entry.getKey(), entry.getValue());
                }
            }
            ChannelFuture f = b.bind().sync();
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Interrupted");
            parentGroup.shutdownGracefully();
            childGroup.shutdownGracefully();
            logger.info("Listener on port " + String.valueOf(this.listeningPort) + " shut down");
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                this.bindErrors.inc();
                logger.severe("Unable to start listener - port " + String.valueOf(this.listeningPort) + " is already in use!");
            } else {
                logger.log(Level.SEVERE, "StreamIngester exception: ", e);
            }
        }
        finally {
            this.activeListeners.dec();
        }
    }

    public static interface FrameDecoderFactory {
        public ChannelInboundHandler getDecoder();
    }
}

