/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.data;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Histogram;
import wavefront.report.ReportPoint;

public class Validation {
    private static final Counter illegalCharacterPoints = Metrics.newCounter((MetricName)new MetricName("point", "", "badchars"));

    public static boolean charactersAreValid(String input) {
        int l = input.length();
        if (l == 0) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            char cur = input.charAt(i);
            if (',' <= cur && cur <= '9' || 'A' <= cur && cur <= 'Z' || 'a' <= cur && cur <= 'z' || cur == '_' || i == 0 && cur == '\u2206' || i == 0 && cur == '\u0394' || i == 0 && cur == '~') continue;
            return false;
        }
        return true;
    }

    public static boolean annotationKeysAreValid(ReportPoint point) {
        for (String key : point.getAnnotations().keySet()) {
            if (Validation.charactersAreValid(key)) continue;
            return false;
        }
        return true;
    }

    public static void validatePoint(ReportPoint point, String source, @Nullable Level validationLevel) {
        Object pointValue = point.getValue();
        if (StringUtils.isBlank((String)point.getHost())) {
            throw new IllegalArgumentException("WF-301: Source/host name is required");
        }
        if (point.getHost().length() >= 1024) {
            throw new IllegalArgumentException("WF-301: Source/host name is too long: " + point.getHost());
        }
        if (point.getMetric().length() >= 1024) {
            throw new IllegalArgumentException("WF-301: Metric name is too long: " + point.getMetric());
        }
        if (!Validation.charactersAreValid(point.getMetric())) {
            illegalCharacterPoints.inc();
            throw new IllegalArgumentException("WF-400 " + source + ": Point metric has illegal character");
        }
        if (point.getAnnotations() != null) {
            if (!Validation.annotationKeysAreValid(point)) {
                throw new IllegalArgumentException("WF-401 " + source + ": Point annotation key has illegal character");
            }
            for (Map.Entry<String, String> tag : point.getAnnotations().entrySet()) {
                if (tag.getKey().length() + tag.getValue().length() < 255) continue;
                throw new IllegalArgumentException("Tag too long: " + tag.getKey() + "=" + tag.getValue());
            }
        }
        if (validationLevel != null && !validationLevel.equals((Object)Level.NO_VALIDATION)) {
            switch (validationLevel) {
                case NUMERIC_ONLY: {
                    Histogram histogram;
                    if (!(pointValue instanceof Long || pointValue instanceof Double || pointValue instanceof Histogram)) {
                        throw new IllegalArgumentException("WF-403 " + source + ": Was not long/double/histogram object");
                    }
                    if (!(pointValue instanceof Histogram) || (histogram = (Histogram)((Object)pointValue)).getCounts().size() != 0 && histogram.getBins().size() != 0 && !histogram.getCounts().stream().allMatch(i -> i == 0)) break;
                    throw new IllegalArgumentException("WF-405 " + source + ": Empty histogram");
                }
            }
        }
    }

    public static enum Level {
        NO_VALIDATION,
        NUMERIC_ONLY;

    }
}

