/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jvm;

import com.sun.management.UnixOperatingSystemMXBean;
import io.dropwizard.metrics5.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;

public class SafeFileDescriptorRatioGauge
extends RatioGauge {
    private final OperatingSystemMXBean os;

    public SafeFileDescriptorRatioGauge() {
        this(ManagementFactory.getOperatingSystemMXBean());
    }

    public SafeFileDescriptorRatioGauge(OperatingSystemMXBean os) {
        this.os = os;
    }

    protected RatioGauge.Ratio getRatio() {
        if (!(this.os instanceof UnixOperatingSystemMXBean)) {
            return RatioGauge.Ratio.of((double)Double.NaN, (double)Double.NaN);
        }
        Long openFds = ((UnixOperatingSystemMXBean)this.os).getOpenFileDescriptorCount();
        Long maxFds = ((UnixOperatingSystemMXBean)this.os).getMaxFileDescriptorCount();
        return RatioGauge.Ratio.of((double)openFds.doubleValue(), (double)maxFds.doubleValue());
    }
}

