/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Histogram;
import wavefront.report.ReportPoint;

public class ReportPointSerializer
implements Function<ReportPoint, String> {
    private static String quote = "\"";

    @Override
    public String apply(ReportPoint point) {
        return ReportPointSerializer.pointToString(point);
    }

    private static String escapeQuotes(String raw) {
        return StringUtils.replace((String)raw, (String)quote, (String)"\\\"");
    }

    private static void appendTagMap(StringBuilder sb, @Nullable Map<String, String> tags) {
        if (tags == null) {
            return;
        }
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            sb.append(' ').append(quote).append(ReportPointSerializer.escapeQuotes(entry.getKey())).append(quote).append("=").append(quote).append(ReportPointSerializer.escapeQuotes(entry.getValue())).append(quote);
        }
    }

    @VisibleForTesting
    public static String pointToString(ReportPoint point) {
        if (point.getValue() instanceof Double || point.getValue() instanceof Long || point.getValue() instanceof String) {
            StringBuilder sb = new StringBuilder(quote).append(ReportPointSerializer.escapeQuotes(point.getMetric())).append(quote).append(" ").append(point.getValue()).append(" ").append(point.getTimestamp() / 1000L).append(" ").append("source=").append(quote).append(ReportPointSerializer.escapeQuotes(point.getHost())).append(quote);
            ReportPointSerializer.appendTagMap(sb, point.getAnnotations());
            return sb.toString();
        }
        if (point.getValue() instanceof Histogram) {
            Histogram h = (Histogram)((Object)point.getValue());
            StringBuilder sb = new StringBuilder();
            switch (h.getDuration()) {
                case 60000: {
                    sb.append("!M ");
                    break;
                }
                case 3600000: {
                    sb.append("!H ");
                    break;
                }
                case 86400000: {
                    sb.append("!D ");
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected histogram duration " + h.getDuration());
                }
            }
            sb.append(point.getTimestamp() / 1000L).append(' ');
            int numCentroids = Math.min(CollectionUtils.size(h.getBins()), CollectionUtils.size(h.getCounts()));
            for (int i = 0; i < numCentroids; ++i) {
                sb.append('#').append(h.getCounts().get(i)).append(' ');
                sb.append(h.getBins().get(i)).append(' ');
            }
            sb.append(quote).append(ReportPointSerializer.escapeQuotes(point.getMetric())).append(quote).append(" ");
            sb.append("source=").append(quote).append(ReportPointSerializer.escapeQuotes(point.getHost())).append(quote);
            ReportPointSerializer.appendTagMap(sb, point.getAnnotations());
            return sb.toString();
        }
        throw new RuntimeException("Unsupported value class: " + point.getValue().getClass().getCanonicalName());
    }
}

