/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.TDigest;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.stats.Sample;
import com.yammer.metrics.stats.Snapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public class WavefrontHistogram
extends Histogram
implements Metric {
    private static final int ACCURACY = 100;
    private static final int MAX_BINS = 10;
    private final Supplier<Long> millis;
    private final LinkedList<MinuteBin> bins;

    public static WavefrontHistogram get(MetricName metricName) {
        return WavefrontHistogram.get(Metrics.defaultRegistry(), metricName);
    }

    public static WavefrontHistogram get(MetricsRegistry registry, MetricName metricName) {
        return WavefrontHistogram.get(registry, metricName, System::currentTimeMillis);
    }

    @VisibleForTesting
    public static synchronized WavefrontHistogram get(MetricsRegistry registry, MetricName metricName, Supplier<Long> clock) {
        TDigestSample sample = new TDigestSample();
        WavefrontHistogram tDigestHistogram = new WavefrontHistogram(sample, clock);
        sample.set(tDigestHistogram);
        return (WavefrontHistogram)registry.getOrAdd(metricName, (Metric)tDigestHistogram);
    }

    private WavefrontHistogram(TDigestSample sample, Supplier<Long> millis) {
        super((Sample)sample);
        this.millis = millis;
        this.bins = new LinkedList();
    }

    public synchronized Collection<MinuteBin> bins(boolean clear) {
        ArrayList<MinuteBin> result = new ArrayList<MinuteBin>(this.bins);
        if (clear) {
            this.bins.clear();
        }
        return result;
    }

    private long minMillis() {
        return this.millis.get() / 60000L * 60000L;
    }

    public void update(int value) {
        this.update((long)value);
    }

    private MinuteBin getCurrent() {
        long minMillis = this.minMillis();
        if (this.bins.isEmpty() || this.bins.getLast().minMillis != minMillis) {
            this.bins.add(new MinuteBin(minMillis));
            if (this.bins.size() > 10) {
                this.bins.removeFirst();
            }
        }
        return this.bins.getLast();
    }

    public synchronized void bulkUpdate(List<Double> means, List<Integer> counts) {
        if (means != null && counts != null) {
            int n = Math.min(means.size(), counts.size());
            MinuteBin current = this.getCurrent();
            for (int i = 0; i < n; ++i) {
                current.dist.add(means.get(i).doubleValue(), counts.get(i).intValue());
            }
        }
    }

    public synchronized void update(long value) {
        this.getCurrent().dist.add((double)value);
    }

    public double mean() {
        Collection centroids = this.snapshot().centroids();
        return centroids.stream().mapToDouble(c -> (double)c.count() * c.mean() / (double)centroids.size()).sum();
    }

    public synchronized double min() {
        return this.bins.stream().map(b -> ((MinuteBin)b).dist.centroids()).mapToDouble(cs -> ((Centroid)Iterables.getFirst((Iterable)cs, (Object)new Centroid(Double.MAX_VALUE))).mean()).min().orElse(Double.NaN);
    }

    public synchronized double max() {
        return this.bins.stream().map(b -> ((MinuteBin)b).dist.centroids()).mapToDouble(cs -> ((Centroid)Iterables.getLast((Iterable)cs, (Object)new Centroid(Double.MIN_VALUE))).mean()).max().orElse(Double.NaN);
    }

    public synchronized long count() {
        return this.bins.stream().mapToLong(bin -> ((MinuteBin)bin).dist.size()).sum();
    }

    public synchronized void clear() {
        if (this.bins != null) {
            this.bins.clear();
        }
    }

    private synchronized TDigest snapshot() {
        AVLTreeDigest snapshot = new AVLTreeDigest(100.0);
        this.bins.forEach(arg_0 -> WavefrontHistogram.lambda$snapshot$6((TDigest)snapshot, arg_0));
        return snapshot;
    }

    public Snapshot getSnapshot() {
        final TDigest snapshot = this.snapshot();
        return new Snapshot(new double[0]){

            public double get75thPercentile() {
                return this.getValue(0.75);
            }

            public double get95thPercentile() {
                return this.getValue(0.95);
            }

            public double get98thPercentile() {
                return this.getValue(0.98);
            }

            public double get999thPercentile() {
                return this.getValue(0.999);
            }

            public double get99thPercentile() {
                return this.getValue(0.99);
            }

            public double getMedian() {
                return this.getValue(0.5);
            }

            public double getValue(double quantile) {
                return snapshot.quantile(quantile);
            }

            public double[] getValues() {
                return new double[0];
            }

            public int size() {
                return (int)snapshot.size();
            }
        };
    }

    public <T> void processWith(MetricProcessor<T> metricProcessor, MetricName metricName, T t) throws Exception {
        metricProcessor.processHistogram(metricName, (Histogram)this, t);
    }

    private static /* synthetic */ void lambda$snapshot$6(TDigest snapshot, MinuteBin bin) {
        snapshot.add(bin.dist);
    }

    private static class TDigestSample
    implements Sample {
        private WavefrontHistogram wfHist;

        private TDigestSample() {
        }

        void set(WavefrontHistogram tdm) {
            this.wfHist = tdm;
        }

        public void clear() {
            this.wfHist.clear();
        }

        public int size() {
            return (int)this.wfHist.count();
        }

        public void update(long l) {
            this.wfHist.update(l);
        }

        public Snapshot getSnapshot() {
            return this.wfHist.getSnapshot();
        }
    }

    public static class MinuteBin {
        private final TDigest dist = new AVLTreeDigest(100.0);
        private final long minMillis;

        MinuteBin(long minMillis) {
            this.minMillis = minMillis;
        }

        public TDigest getDist() {
            return this.dist;
        }

        public long getMinMillis() {
            return this.minMillis;
        }
    }
}

