/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.proxy;

import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.tracing.SpanLog;
import com.wavefront.sdk.proxy.ProxyConnectionHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class WavefrontProxyClient
implements WavefrontSender,
Runnable {
    private static final Logger logger = Logger.getLogger(WavefrontProxyClient.class.getCanonicalName());
    @Nullable
    private final ProxyConnectionHandler metricsProxyConnectionHandler;
    @Nullable
    private final ProxyConnectionHandler histogramProxyConnectionHandler;
    @Nullable
    private final ProxyConnectionHandler tracingProxyConnectionHandler;
    private final String defaultSource;
    private final ScheduledExecutorService scheduler;

    private WavefrontProxyClient(Builder builder) {
        String tempSource = "unknown";
        try {
            tempSource = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            logger.log(Level.WARNING, "Unable to resolve local host name. Source will default to 'unknown'", ex);
        }
        this.defaultSource = tempSource;
        this.metricsProxyConnectionHandler = builder.metricsPort == null ? null : new ProxyConnectionHandler(new InetSocketAddress(builder.proxyHostName, (int)builder.metricsPort), builder.socketFactory);
        this.histogramProxyConnectionHandler = builder.distributionPort == null ? null : new ProxyConnectionHandler(new InetSocketAddress(builder.proxyHostName, (int)builder.distributionPort), builder.socketFactory);
        this.tracingProxyConnectionHandler = builder.tracingPort == null ? null : new ProxyConnectionHandler(new InetSocketAddress(builder.proxyHostName, (int)builder.tracingPort), builder.socketFactory);
        this.scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("wavefrontProxySender"));
        this.scheduler.scheduleAtFixedRate(this, 1L, builder.flushIntervalSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void sendMetric(String name, double value, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        if (this.metricsProxyConnectionHandler == null) {
            logger.warning("Can't send data to Wavefront. Please configure metrics port for Wavefront proxy");
            return;
        }
        if (!this.metricsProxyConnectionHandler.isConnected()) {
            try {
                this.metricsProxyConnectionHandler.connect();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            try {
                String lineData = Utils.metricToLineData(name, value, timestamp, source, tags, this.defaultSource);
                this.metricsProxyConnectionHandler.sendData(lineData);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            this.metricsProxyConnectionHandler.incrementFailureCount();
            throw e;
        }
    }

    @Override
    public void sendDistribution(String name, List<Pair<Double, Integer>> centroids, Set<HistogramGranularity> histogramGranularities, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        if (this.histogramProxyConnectionHandler == null) {
            logger.warning("Can't send data to Wavefront. Please configure histogram distribution port for Wavefront proxy");
            return;
        }
        if (!this.histogramProxyConnectionHandler.isConnected()) {
            try {
                this.histogramProxyConnectionHandler.connect();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            String lineData = Utils.histogramToLineData(name, centroids, histogramGranularities, timestamp, source, tags, this.defaultSource);
            try {
                this.histogramProxyConnectionHandler.sendData(lineData);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            this.histogramProxyConnectionHandler.incrementFailureCount();
            throw e;
        }
    }

    @Override
    public void sendSpan(String name, long startMillis, long durationMillis, @Nullable String source, UUID traceId, UUID spanId, @Nullable List<UUID> parents, @Nullable List<UUID> followsFrom, @Nullable List<Pair<String, String>> tags, @Nullable List<SpanLog> spanLogs) throws IOException {
        if (this.tracingProxyConnectionHandler == null) {
            logger.warning("Can't send data to Wavefront. Please configure tracing port for Wavefront proxy");
            return;
        }
        if (!this.tracingProxyConnectionHandler.isConnected()) {
            try {
                this.tracingProxyConnectionHandler.connect();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            String lineData = Utils.tracingSpanToLineData(name, startMillis, durationMillis, source, traceId, spanId, parents, followsFrom, tags, spanLogs, this.defaultSource);
            try {
                this.tracingProxyConnectionHandler.sendData(lineData);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            this.tracingProxyConnectionHandler.incrementFailureCount();
            throw e;
        }
    }

    @Override
    public void run() {
        try {
            this.flush();
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "Unable to report to Wavefront cluster", ex);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.metricsProxyConnectionHandler != null) {
            this.metricsProxyConnectionHandler.flush();
        }
        if (this.histogramProxyConnectionHandler != null) {
            this.histogramProxyConnectionHandler.flush();
        }
        if (this.tracingProxyConnectionHandler != null) {
            this.tracingProxyConnectionHandler.flush();
        }
    }

    @Override
    public int getFailureCount() {
        int failureCount = 0;
        if (this.metricsProxyConnectionHandler != null) {
            failureCount += this.metricsProxyConnectionHandler.getFailureCount();
        }
        if (this.histogramProxyConnectionHandler != null) {
            failureCount += this.histogramProxyConnectionHandler.getFailureCount();
        }
        if (this.tracingProxyConnectionHandler != null) {
            failureCount += this.tracingProxyConnectionHandler.getFailureCount();
        }
        return failureCount;
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error flushing buffer", e);
        }
        try {
            this.scheduler.shutdownNow();
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, "shutdown error", ex);
        }
        if (this.metricsProxyConnectionHandler != null) {
            try {
                this.metricsProxyConnectionHandler.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing metricsProxyConnectionHandler", e);
            }
        }
        if (this.histogramProxyConnectionHandler != null) {
            try {
                this.histogramProxyConnectionHandler.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing histogramProxyConnectionHandler", e);
            }
        }
        if (this.tracingProxyConnectionHandler != null) {
            try {
                this.tracingProxyConnectionHandler.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing tracingProxyConnectionHandler", e);
            }
        }
    }

    public static class Builder {
        private final String proxyHostName;
        private Integer metricsPort;
        private Integer distributionPort;
        private Integer tracingPort;
        private SocketFactory socketFactory = SocketFactory.getDefault();
        private int flushIntervalSeconds = 5;

        public Builder(String proxyHostName) {
            this.proxyHostName = proxyHostName;
        }

        public Builder metricsPort(int metricsPort) {
            this.metricsPort = metricsPort;
            return this;
        }

        public Builder distributionPort(int distributionPort) {
            this.distributionPort = distributionPort;
            return this;
        }

        public Builder tracingPort(int tracingPort) {
            this.tracingPort = tracingPort;
            return this;
        }

        public Builder socketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder flushIntervalSeconds(int flushIntervalSeconds) {
            this.flushIntervalSeconds = flushIntervalSeconds;
            return this;
        }

        public WavefrontProxyClient build() {
            return new WavefrontProxyClient(this);
        }
    }
}

