/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk;

import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.direct.ingestion.WavefrontDirectIngestionClient;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.proxy.WavefrontProxyClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;

public class Main {
    private static void sendMetricViaProxy(WavefrontProxyClient wavefrontProxyClient) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("datacenter", "dc1");
            }
        };
        wavefrontProxyClient.sendMetric("new-york.power.usage", 42422.0, null, "localhost", (Map<String, String>)tags);
        System.out.println("Sent metric: 'new-york.power.usage' to proxy");
    }

    private static void sendMetricViaDirectIngestion(WavefrontDirectIngestionClient wavefrontDirectIngestionClient) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("datacenter", "dc1");
            }
        };
        wavefrontDirectIngestionClient.sendMetric("new-york.power.usage", 42422.0, null, "localhost", (Map<String, String>)tags);
        System.out.println("Sent metric: 'new-york.power.usage' to direct ingestion API");
    }

    private static void sendDeltaCounterViaProxy(WavefrontProxyClient wavefrontProxyClient) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("image-format", "jpeg");
            }
        };
        wavefrontProxyClient.sendDeltaCounter("lambda.thumbnail.generate", 10.0, "lambda_thumbnail_service", (Map<String, String>)tags);
        System.out.println("Sent metric: 'lambda.thumbnail.generate' to proxy");
    }

    private static void sendDeltaCounterViaDirectIngestion(WavefrontDirectIngestionClient wavefrontDirectIngestionClient) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("image-format", "jpeg");
            }
        };
        wavefrontDirectIngestionClient.sendDeltaCounter("lambda.thumbnail.generate", 10.0, "lambda_thumbnail_service", (Map<String, String>)tags);
        System.out.println("Sent metric: 'lambda.thumbnail.generate' to direct ingestion API");
    }

    private static void sendHistogramViaProxy(WavefrontProxyClient wavefrontProxyClient) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("region", "us-west");
            }
        };
        HashSet<HistogramGranularity> histogramGranularities = new HashSet<HistogramGranularity>();
        histogramGranularities.add(HistogramGranularity.MINUTE);
        histogramGranularities.add(HistogramGranularity.HOUR);
        histogramGranularities.add(HistogramGranularity.DAY);
        wavefrontProxyClient.sendDistribution("request.latency", Arrays.asList(new Pair<Double, Integer>(30.0, 20), new Pair<Double, Integer>(5.1, 10)), histogramGranularities, null, "appServer1", (Map<String, String>)tags);
        System.out.println("Sent histogram: 'request.latency' to proxy");
    }

    private static void sendHistogramViaDirectIngestion(WavefrontDirectIngestionClient wavefrontDirectIngestionClient) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("region", "us-west");
            }
        };
        HashSet<HistogramGranularity> histogramGranularities = new HashSet<HistogramGranularity>();
        histogramGranularities.add(HistogramGranularity.MINUTE);
        histogramGranularities.add(HistogramGranularity.HOUR);
        histogramGranularities.add(HistogramGranularity.DAY);
        wavefrontDirectIngestionClient.sendDistribution("request.latency", Arrays.asList(new Pair<Double, Integer>(30.0, 20), new Pair<Double, Integer>(5.1, 10)), histogramGranularities, null, "appServer1", (Map<String, String>)tags);
        System.out.println("Sent histogram: 'request.latency' to direction ingestion API");
    }

    private static void sendTracingSpanViaProxy(WavefrontProxyClient wavefrontProxyClient) throws IOException {
        wavefrontProxyClient.sendSpan("getAllUsers", 1533529977L, 343500L, "localhost", UUID.fromString("7b3bf470-9456-11e8-9eb6-529269fb1459"), UUID.fromString("0313bafe-9457-11e8-9eb6-529269fb1459"), Arrays.asList(UUID.fromString("2f64e538-9457-11e8-9eb6-529269fb1459")), null, Arrays.asList(new Pair<String, String>("application", "Wavefront"), new Pair<String, String>("http.method", "GET")), null);
        System.out.println("Sent tracing span: 'getAllUsers' to proxy");
    }

    private static void sendTracingSpanViaDirectIngestion(WavefrontDirectIngestionClient wavefrontDirectIngestionClient) throws IOException {
        wavefrontDirectIngestionClient.sendSpan("getAllUsers", 1493773500L, 343500L, "localhost", UUID.fromString("7b3bf470-9456-11e8-9eb6-529269fb1459"), UUID.fromString("0313bafe-9457-11e8-9eb6-529269fb1459"), Arrays.asList(UUID.fromString("2f64e538-9457-11e8-9eb6-529269fb1459")), null, Arrays.asList(new Pair<String, String>("application", "Wavefront"), new Pair<String, String>("http.method", "GET")), null);
        System.out.println("Sent tracing span: 'getAllUsers' to direct ingestion API");
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        String wavefrontServer = args[0];
        String token = args[1];
        String proxyHost = args.length < 3 ? null : args[2];
        String metricsPort = args.length < 4 ? null : args[3];
        String distributionPort = args.length < 5 ? null : args[4];
        String tracingPort = args.length < 6 ? null : args[5];
        WavefrontProxyClient.Builder builder = new WavefrontProxyClient.Builder(proxyHost);
        if (metricsPort != null) {
            builder.metricsPort(Integer.parseInt(metricsPort));
        }
        if (distributionPort != null) {
            builder.distributionPort(Integer.parseInt(distributionPort));
        }
        if (tracingPort != null) {
            builder.tracingPort(Integer.parseInt(tracingPort));
        }
        WavefrontProxyClient wavefrontProxyClient = builder.build();
        WavefrontDirectIngestionClient wavefrontDirectIngestionClient = new WavefrontDirectIngestionClient.Builder(wavefrontServer, token).build();
        while (true) {
            Main.sendMetricViaProxy(wavefrontProxyClient);
            Main.sendDeltaCounterViaProxy(wavefrontProxyClient);
            Main.sendHistogramViaProxy(wavefrontProxyClient);
            Main.sendTracingSpanViaProxy(wavefrontProxyClient);
            wavefrontProxyClient.flush();
            Main.sendMetricViaDirectIngestion(wavefrontDirectIngestionClient);
            Main.sendDeltaCounterViaDirectIngestion(wavefrontDirectIngestionClient);
            Main.sendHistogramViaDirectIngestion(wavefrontDirectIngestionClient);
            Main.sendTracingSpanViaDirectIngestion(wavefrontDirectIngestionClient);
            Thread.sleep(5000L);
        }
    }
}

