/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common;

import com.wavefront.sdk.common.metrics.WavefrontSdkCounter;
import com.wavefront.sdk.common.metrics.WavefrontSdkMetricsRegistry;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class ReconnectingSocket {
    private static final Logger logger = Logger.getLogger(ReconnectingSocket.class.getCanonicalName());
    private static final int SERVER_READ_TIMEOUT_MILLIS = 2000;
    private static final int SERVER_POLL_INTERVAL_MILLIS = 4000;
    private final String host;
    private final int port;
    private final SocketFactory socketFactory;
    private volatile boolean serverTerminated;
    private final Timer pollingTimer;
    private AtomicReference<Socket> underlyingSocket;
    private AtomicReference<BufferedOutputStream> socketOutputStream;
    private WavefrontSdkCounter writeSuccesses;
    private WavefrontSdkCounter writeErrors;
    private WavefrontSdkCounter flushSuccesses;
    private WavefrontSdkCounter flushErrors;
    private WavefrontSdkCounter resetSuccesses;
    private WavefrontSdkCounter resetErrors;

    public ReconnectingSocket(String host, int port, SocketFactory socketFactory, WavefrontSdkMetricsRegistry sdkMetricsRegistry, String entityPrefix) throws IOException {
        this.host = host;
        this.port = port;
        this.serverTerminated = false;
        this.socketFactory = socketFactory;
        this.underlyingSocket = new AtomicReference<Socket>(socketFactory.createSocket(host, port));
        this.underlyingSocket.get().setSoTimeout(2000);
        this.socketOutputStream = new AtomicReference<BufferedOutputStream>(new BufferedOutputStream(this.underlyingSocket.get().getOutputStream()));
        this.pollingTimer = new Timer();
        this.pollingTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ReconnectingSocket.this.maybeReconnect();
            }
        }, 4000L, 4000L);
        entityPrefix = entityPrefix == null || entityPrefix.isEmpty() ? "" : entityPrefix + ".";
        this.writeSuccesses = sdkMetricsRegistry.newCounter(entityPrefix + "write.success");
        this.writeErrors = sdkMetricsRegistry.newCounter(entityPrefix + "write.errors");
        this.flushSuccesses = sdkMetricsRegistry.newCounter(entityPrefix + "flush.success");
        this.flushErrors = sdkMetricsRegistry.newCounter(entityPrefix + "flush.errors");
        this.resetSuccesses = sdkMetricsRegistry.newCounter(entityPrefix + "reset.success");
        this.resetErrors = sdkMetricsRegistry.newCounter(entityPrefix + "reset.errors");
    }

    private void maybeReconnect() {
        try {
            int bytesRead;
            byte[] message = new byte[1000];
            try {
                bytesRead = this.underlyingSocket.get().getInputStream().read(message);
            }
            catch (IOException e) {
                return;
            }
            if (bytesRead == -1) {
                this.serverTerminated = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot poll server for TCP FIN.");
        }
    }

    /*
     * Loose catch block
     */
    private synchronized void resetSocket() throws IOException {
        block13: {
            try {
                BufferedOutputStream old = this.socketOutputStream.get();
                if (old != null) {
                    old.close();
                }
                this.serverTerminated = false;
                try {
                    this.underlyingSocket.getAndSet(this.socketFactory.createSocket(this.host, this.port)).close();
                }
                catch (SocketException e) {
                    logger.log(Level.WARNING, "Could not close old socket.", e);
                }
                this.underlyingSocket.get().setSoTimeout(2000);
                this.socketOutputStream.set(new BufferedOutputStream(this.underlyingSocket.get().getOutputStream()));
                this.resetSuccesses.inc();
                logger.log(Level.INFO, String.format("Successfully reset connection to %s:%d", this.host, this.port));
                break block13;
                catch (SocketException e) {
                    try {
                        logger.log(Level.INFO, "Could not flush to socket.", e);
                        this.serverTerminated = false;
                    }
                    catch (Throwable throwable) {
                        this.serverTerminated = false;
                        try {
                            this.underlyingSocket.getAndSet(this.socketFactory.createSocket(this.host, this.port)).close();
                        }
                        catch (SocketException e2) {
                            logger.log(Level.WARNING, "Could not close old socket.", e2);
                        }
                        this.underlyingSocket.get().setSoTimeout(2000);
                        this.socketOutputStream.set(new BufferedOutputStream(this.underlyingSocket.get().getOutputStream()));
                        this.resetSuccesses.inc();
                        logger.log(Level.INFO, String.format("Successfully reset connection to %s:%d", this.host, this.port));
                        throw throwable;
                    }
                    try {
                        this.underlyingSocket.getAndSet(this.socketFactory.createSocket(this.host, this.port)).close();
                    }
                    catch (SocketException e3) {
                        logger.log(Level.WARNING, "Could not close old socket.", e3);
                    }
                    this.underlyingSocket.get().setSoTimeout(2000);
                    this.socketOutputStream.set(new BufferedOutputStream(this.underlyingSocket.get().getOutputStream()));
                    this.resetSuccesses.inc();
                    logger.log(Level.INFO, String.format("Successfully reset connection to %s:%d", this.host, this.port));
                }
            }
            catch (Exception e) {
                this.resetErrors.inc();
                throw e;
            }
        }
    }

    public void write(String message) throws Exception {
        try {
            if (this.serverTerminated) {
                throw new Exception("Remote server terminated.");
            }
            this.socketOutputStream.get().write(message.getBytes());
            this.writeSuccesses.inc();
        }
        catch (Exception e) {
            try {
                logger.log(Level.WARNING, "Attempting to reset socket connection.", e);
                this.resetSocket();
                this.socketOutputStream.get().write(message.getBytes());
                this.writeSuccesses.inc();
            }
            catch (Exception e2) {
                this.writeErrors.inc();
                throw e2;
            }
        }
    }

    public void flush() throws IOException {
        try {
            this.socketOutputStream.get().flush();
            this.flushSuccesses.inc();
        }
        catch (Exception e) {
            this.flushErrors.inc();
            logger.log(Level.WARNING, "Attempting to reset socket connection.", e);
            this.resetSocket();
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.pollingTimer.cancel();
            this.socketOutputStream.get().close();
        }
    }
}

