/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.logging;

import com.wavefront.java_sdk.com.google.common.cache.CacheBuilder;
import com.wavefront.java_sdk.com.google.common.cache.CacheLoader;
import com.wavefront.java_sdk.com.google.common.cache.LoadingCache;
import com.wavefront.java_sdk.com.google.common.util.concurrent.RateLimiter;
import com.wavefront.sdk.common.logging.DelegatingLogger;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MessageDedupingLogger
extends DelegatingLogger {
    private final LoadingCache<String, RateLimiter> rateLimiterCache;

    public MessageDedupingLogger(Logger delegate, long maximumSize, final double rateLimit) {
        super(delegate);
        this.rateLimiterCache = CacheBuilder.newBuilder().expireAfterAccess((long)(2.0 / rateLimit), TimeUnit.SECONDS).maximumSize(maximumSize).build(new CacheLoader<String, RateLimiter>(){

            @Override
            public RateLimiter load(String s) {
                return RateLimiter.create(rateLimit);
            }
        });
    }

    @Override
    public void log(Level level, String message) {
        try {
            if (Objects.requireNonNull(this.rateLimiterCache.get(message)).tryAcquire()) {
                this.log(new LogRecord(level, message));
            }
        }
        catch (ExecutionException e) {
            this.log(new LogRecord(level, message));
        }
    }

    public void log(String messageDedupingKey, Level level, String message) {
        try {
            if (Objects.requireNonNull(this.rateLimiterCache.get(messageDedupingKey)).tryAcquire()) {
                this.log(new LogRecord(level, message));
            }
        }
        catch (ExecutionException e) {
            this.log(new LogRecord(level, message));
        }
    }
}

