/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.direct.ingestion;

import com.wavefront.sdk.direct.ingestion.DataIngesterAPI;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.zip.GZIPOutputStream;

@Deprecated
public class DataIngesterService
implements DataIngesterAPI {
    private final String token;
    private final URI uri;
    private static final String BAD_REQUEST = "Bad client request";
    private static final int CONNECT_TIMEOUT_MILLIS = 30000;
    private static final int READ_TIMEOUT_MILLIS = 10000;

    DataIngesterService(String server, String token) {
        this.token = token;
        this.uri = URI.create(server);
    }

    @Override
    public int report(String format, InputStream stream) throws IOException {
        int statusCode;
        block16: {
            statusCode = 400;
            HttpURLConnection urlConn = null;
            try {
                String originalPath = this.uri.getPath() != null ? this.uri.getPath() : "";
                URL url = new URL(this.uri.getScheme(), this.uri.getHost(), this.uri.getPort(), originalPath + "/report?f=" + format);
                urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setDoOutput(true);
                urlConn.addRequestProperty("Content-Type", "application/octet-stream");
                urlConn.addRequestProperty("Content-Encoding", "gzip");
                urlConn.addRequestProperty("Authorization", "Bearer " + this.token);
                urlConn.setConnectTimeout(30000);
                urlConn.setReadTimeout(10000);
                try (GZIPOutputStream gzipOS = new GZIPOutputStream(urlConn.getOutputStream());){
                    byte[] buffer = new byte[4096];
                    while (stream.available() > 0) {
                        gzipOS.write(buffer, 0, stream.read(buffer));
                    }
                    gzipOS.flush();
                }
                statusCode = urlConn.getResponseCode();
                this.readAndClose(urlConn.getInputStream());
            }
            catch (IOException ex) {
                if (urlConn == null) break block16;
                statusCode = urlConn.getResponseCode();
                this.readAndClose(urlConn.getErrorStream());
            }
        }
        return statusCode;
    }

    private void readAndClose(InputStream stream) throws IOException {
        if (stream != null) {
            try (InputStream is = stream;){
                byte[] buffer = new byte[4096];
                while (is.read(buffer) > 0) {
                }
            }
        }
    }
}

