/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.example.trade;

import com.webull.openapi.common.Region;
import com.webull.openapi.common.dict.Category;
import com.webull.openapi.common.dict.ComboType;
import com.webull.openapi.common.dict.EntrustType;
import com.webull.openapi.common.dict.InstrumentSuperType;
import com.webull.openapi.common.dict.Markets;
import com.webull.openapi.common.dict.OptionStrategy;
import com.webull.openapi.common.dict.OptionType;
import com.webull.openapi.common.dict.OrderSide;
import com.webull.openapi.common.dict.OrderTIF;
import com.webull.openapi.common.dict.OrderType;
import com.webull.openapi.example.config.Env;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.execption.ServerException;
import com.webull.openapi.http.HttpApiConfig;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.trade.api.http.TradeHttpApiV2Service;
import com.webull.openapi.trade.api.request.v2.OptionOrder;
import com.webull.openapi.trade.api.request.v2.OptionOrderItem;
import com.webull.openapi.trade.api.request.v2.OptionOrderItemLeg;
import com.webull.openapi.trade.api.request.v2.TradeOrder;
import com.webull.openapi.trade.api.request.v2.TradeOrderItem;
import com.webull.openapi.trade.api.response.OAuthCommonPositionContractVO;
import com.webull.openapi.trade.api.response.v2.Account;
import com.webull.openapi.trade.api.response.v2.AccountBalanceInfo;
import com.webull.openapi.trade.api.response.v2.OrderHistory;
import com.webull.openapi.trade.api.response.v2.PreviewOrderResponse;
import com.webull.openapi.trade.api.response.v2.TradeOrderResponse;
import com.webull.openapi.utils.CollectionUtils;
import com.webull.openapi.utils.GUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class TradeV2Api {
    private static final Logger logger = LoggerFactory.getLogger(TradeV2Api.class);

    public static void main(String[] args) {
        try {
            HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId(Env.REGION_ID).build();
            TradeHttpApiV2Service apiService = new TradeHttpApiV2Service(apiConfig);
            List accounts = apiService.listAccount();
            logger.info("Accounts: {}", (Object)accounts);
            String accountId = null;
            if (CollectionUtils.isNotEmpty((Collection)accounts)) {
                accountId = ((Account)accounts.get(0)).getAccountId();
            }
            AccountBalanceInfo accountBalanceInfo = apiService.balanceAccount(accountId);
            logger.info("balanceBase: {}", (Object)accountBalanceInfo);
            List accountPositionsInfos = apiService.positionsAccount(accountId);
            logger.info("accountPositions: {}", (Object)accountPositionsInfos);
            TradeOrder tradeOrder = new TradeOrder();
            ArrayList<TradeOrderItem> newOrders = new ArrayList<TradeOrderItem>();
            TradeOrderItem placeOne = new TradeOrderItem();
            newOrders.add(placeOne);
            placeOne.setSymbol("AAPL");
            placeOne.setInstrumentType(InstrumentSuperType.EQUITY.name());
            placeOne.setMarket(Region.us.name().toUpperCase());
            placeOne.setOrderType(OrderType.MARKET.name());
            placeOne.setQuantity("100");
            placeOne.setLimitPrice("400");
            placeOne.setTotalCashAmount("100");
            placeOne.setSupportTradingSession("N");
            placeOne.setSide(OrderSide.BUY.name());
            placeOne.setTimeInForce(OrderTIF.DAY.name());
            placeOne.setEntrustType(EntrustType.QTY.name());
            tradeOrder.setNewOrders(newOrders);
            PreviewOrderResponse previewOrderResponse = apiService.previewOrder(accountId, tradeOrder);
            logger.info("previewOrderResponse: {}", (Object)previewOrderResponse);
            String clientOrderId = GUID.get();
            placeOne.setClientOrderId(clientOrderId);
            HashMap<String, String> customHeadersMap = new HashMap<String, String>();
            customHeadersMap.put("category", Category.US_STOCK.name());
            apiService.addCustomHeaders(customHeadersMap);
            TradeOrderResponse tradePlaceOrderResponse = apiService.placeOrder(accountId, tradeOrder);
            apiService.removeCustomHeaders();
            logger.info("tradePlaceOrderResponse: {}", (Object)tradePlaceOrderResponse);
            Thread.sleep(1000L);
            TradeOrder modifyTradeOrder = new TradeOrder();
            ArrayList<TradeOrderItem> modifyOrders = new ArrayList<TradeOrderItem>();
            TradeOrderItem modifyOne = new TradeOrderItem();
            modifyOne.setClientOrderId(tradePlaceOrderResponse.getClientOrderId());
            modifyOne.setLimitPrice("45");
            modifyOne.setQuantity("100");
            modifyOrders.add(modifyOne);
            modifyTradeOrder.setModifyOrders(modifyOrders);
            TradeOrderResponse tradeReplaceOrderResponse = apiService.replaceOrder(accountId, modifyTradeOrder);
            logger.info("tradeReplaceOrderResponse: {}", (Object)tradeReplaceOrderResponse);
            Thread.sleep(1000L);
            TradeOrder cancelTradeOrder = new TradeOrder();
            cancelTradeOrder.setClientOrderId(tradePlaceOrderResponse.getClientOrderId());
            TradeOrderResponse tradeCancelOrderResponse = apiService.cancelOrder(accountId, cancelTradeOrder);
            logger.info("tradeCancelOrderResponse: {}", (Object)tradeCancelOrderResponse);
            List tradeOrderItems = apiService.listOrders(accountId, Integer.valueOf(10), "2024-09-25", null, null);
            logger.info("tradeOrderItems: {}", (Object)tradeOrderItems);
            OrderHistory orderDetailResponse = apiService.getOrderDetails(accountId, clientOrderId);
            logger.info("orderDetailResponse: {}", (Object)orderDetailResponse);
            OptionOrderItemLeg optionOrderItemLeg = new OptionOrderItemLeg();
            optionOrderItemLeg.setSide(OrderSide.BUY.name());
            optionOrderItemLeg.setQuantity("1");
            optionOrderItemLeg.setSymbol("AAPL");
            optionOrderItemLeg.setStrikePrice("250");
            optionOrderItemLeg.setInitExpDate("2025-08-15");
            optionOrderItemLeg.setInstrumentType(InstrumentSuperType.OPTION.name());
            optionOrderItemLeg.setOptionType(OptionType.CALL.name());
            optionOrderItemLeg.setMarket(Markets.US.name());
            ArrayList<OptionOrderItemLeg> optionOrderItemLegList = new ArrayList<OptionOrderItemLeg>();
            optionOrderItemLegList.add(optionOrderItemLeg);
            OptionOrderItem optionOrderItem = new OptionOrderItem();
            optionOrderItem.setClientOrderId(GUID.get());
            optionOrderItem.setComboType(ComboType.NORMAL.name());
            optionOrderItem.setOptionStrategy(OptionStrategy.SINGLE.name());
            optionOrderItem.setSide(OrderSide.BUY.name());
            optionOrderItem.setOrderType(OrderType.LIMIT.name());
            optionOrderItem.setTimeInForce(OrderTIF.GTC.name());
            optionOrderItem.setLimitPrice("2");
            optionOrderItem.setQuantity("1");
            optionOrderItem.setEntrustType(EntrustType.QTY.name());
            optionOrderItem.setOrders(optionOrderItemLegList);
            ArrayList<OptionOrderItem> optionOrderItemList = new ArrayList<OptionOrderItem>();
            optionOrderItemList.add(optionOrderItem);
            OptionOrder optionOrder = new OptionOrder();
            optionOrder.setNewOrders(optionOrderItemList);
            logger.info("previewOptionRequest: {}", (Object)optionOrder);
            PreviewOrderResponse previewOptionResponse = apiService.previewOption(accountId, optionOrder);
            logger.info("previewOptionResponse: {}", (Object)previewOptionResponse);
            logger.info("placeOptionRequest: {}", (Object)optionOrder);
            HashMap<String, String> optionCustomHeadersMap = new HashMap<String, String>();
            optionCustomHeadersMap.put("category", Category.US_OPTION.name());
            apiService.addCustomHeaders(optionCustomHeadersMap);
            TradeOrderResponse placeOptionResponse = apiService.placeOption(accountId, optionOrder);
            apiService.removeCustomHeaders();
            logger.info("placeOptionResponse: {}", (Object)placeOptionResponse);
            Thread.sleep(5000L);
            OptionOrderItemLeg optionReplaceItemLeg = new OptionOrderItemLeg();
            optionReplaceItemLeg.setQuantity("2");
            optionReplaceItemLeg.setClientOrderId(optionOrderItem.getClientOrderId());
            ArrayList<OptionOrderItemLeg> optionReplaceItemLegList = new ArrayList<OptionOrderItemLeg>();
            optionReplaceItemLegList.add(optionReplaceItemLeg);
            OptionOrderItem optionReplaceItem = new OptionOrderItem();
            optionReplaceItem.setClientOrderId(optionOrderItem.getClientOrderId());
            optionReplaceItem.setLimitPrice("3");
            optionReplaceItem.setQuantity("2");
            optionReplaceItem.setOrders(optionReplaceItemLegList);
            ArrayList<OptionOrderItem> optionReplaceItemList = new ArrayList<OptionOrderItem>();
            optionReplaceItemList.add(optionReplaceItem);
            OptionOrder optionReplace = new OptionOrder();
            optionReplace.setModifyOrders(optionReplaceItemList);
            logger.info("replaceOptionRequest: {}", (Object)optionReplace);
            TradeOrderResponse replaceOptionResponse = apiService.replaceOption(accountId, optionReplace);
            logger.info("replaceOptionResponse: {}", (Object)replaceOptionResponse);
            Thread.sleep(5000L);
            OptionOrder cancelTradeOption = new OptionOrder();
            cancelTradeOption.setClientOrderId(optionOrderItem.getClientOrderId());
            logger.info("cancelOptionRequest: {}", (Object)cancelTradeOption);
            TradeOrderResponse cancelOptionResponse = apiService.cancelOption(accountId, cancelTradeOption);
            logger.info("cancelOptionResponse: {}", (Object)cancelOptionResponse);
            accountId = "";
            String tickserId = "";
            String startId = "";
            Integer size = 10;
            OAuthCommonPositionContractVO contractVO = apiService.getCommonPositionDetail(accountId, tickserId, startId, size);
            logger.info("OAuthCommonPositionContractVO:{}", (Object)contractVO);
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }
}

