/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.samples.trade;

import com.webull.openapi.core.common.dict.Category;
import com.webull.openapi.core.common.dict.ComboType;
import com.webull.openapi.core.common.dict.EntrustType;
import com.webull.openapi.core.common.dict.InstrumentSuperType;
import com.webull.openapi.core.common.dict.Markets;
import com.webull.openapi.core.common.dict.OptionStrategy;
import com.webull.openapi.core.common.dict.OptionType;
import com.webull.openapi.core.common.dict.OrderSide;
import com.webull.openapi.core.common.dict.OrderTIF;
import com.webull.openapi.core.common.dict.OrderType;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.utils.CollectionUtils;
import com.webull.openapi.core.utils.GUID;
import com.webull.openapi.trade.request.v2.OptionOrder;
import com.webull.openapi.trade.request.v2.OptionOrderItem;
import com.webull.openapi.trade.request.v2.OptionOrderItemLeg;
import com.webull.openapi.trade.request.v2.TradeOrder;
import com.webull.openapi.trade.request.v2.TradeOrderItem;
import com.webull.openapi.trade.response.v2.Account;
import com.webull.openapi.trade.response.v2.AccountBalanceInfo;
import com.webull.openapi.trade.response.v2.OrderHistory;
import com.webull.openapi.trade.response.v2.PreviewOrderResponse;
import com.webull.openapi.trade.response.v2.TradeOrderResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class TradeClientV2 {
    private static final Logger logger = LoggerFactory.getLogger(TradeClientV2.class);

    public static void main(String[] args) throws InterruptedException {
        HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId("<your_region_id>").build();
        com.webull.openapi.trade.TradeClientV2 apiService = new com.webull.openapi.trade.TradeClientV2(apiConfig);
        List accounts = apiService.listAccount();
        logger.info("Accounts: {}", (Object)accounts);
        String accountId = null;
        if (CollectionUtils.isNotEmpty((Collection)accounts)) {
            accountId = ((Account)accounts.get(0)).getAccountId();
        }
        AccountBalanceInfo accountBalanceInfo = apiService.balanceAccount(accountId);
        logger.info("balanceBase: {}", (Object)accountBalanceInfo);
        List accountPositionsInfos = apiService.positionsAccount(accountId);
        logger.info("accountPositions: {}", (Object)accountPositionsInfos);
        TradeOrder tradeOrder = new TradeOrder();
        ArrayList<TradeOrderItem> newOrders = new ArrayList<TradeOrderItem>();
        String clientOrderId = GUID.get();
        TradeOrderItem placeOne = new TradeOrderItem();
        newOrders.add(placeOne);
        placeOne.setSymbol("AAPL");
        placeOne.setInstrumentType(InstrumentSuperType.EQUITY.name());
        placeOne.setMarket(Markets.US.name());
        placeOne.setOrderType(OrderType.LIMIT.name());
        placeOne.setQuantity("1");
        placeOne.setLimitPrice("190");
        placeOne.setSupportTradingSession("N");
        placeOne.setSide(OrderSide.BUY.name());
        placeOne.setTimeInForce(OrderTIF.GTC.name());
        placeOne.setEntrustType(EntrustType.QTY.name());
        placeOne.setClientOrderId(clientOrderId);
        tradeOrder.setNewOrders(newOrders);
        logger.info("previewOrderRequest: {}", (Object)tradeOrder);
        PreviewOrderResponse previewOrderResponse = apiService.previewOrder(accountId, tradeOrder);
        logger.info("previewOrderResponse: {}", (Object)previewOrderResponse);
        HashMap<String, String> customHeadersMap = new HashMap<String, String>();
        customHeadersMap.put("category", Category.US_STOCK.name());
        apiService.addCustomHeaders(customHeadersMap);
        logger.info("placeOrderRequest: {}", (Object)tradeOrder);
        TradeOrderResponse tradePlaceOrderResponse = apiService.placeOrder(accountId, tradeOrder);
        apiService.removeCustomHeaders();
        logger.info("placeOrderResponse: {}", (Object)tradePlaceOrderResponse);
        TradeClientV2.doSleep();
        TradeOrder modifyTradeOrder = new TradeOrder();
        ArrayList<TradeOrderItem> modifyOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem modifyOne = new TradeOrderItem();
        modifyOne.setClientOrderId(tradePlaceOrderResponse.getClientOrderId());
        modifyOne.setLimitPrice("180");
        modifyOne.setQuantity("2");
        modifyOrders.add(modifyOne);
        modifyTradeOrder.setModifyOrders(modifyOrders);
        logger.info("replaceOrderRequest: {}", (Object)tradeOrder);
        TradeOrderResponse tradeReplaceOrderResponse = apiService.replaceOrder(accountId, modifyTradeOrder);
        logger.info("replaceOrderResponse: {}", (Object)tradeReplaceOrderResponse);
        TradeClientV2.doSleep();
        TradeOrder cancelTradeOrder = new TradeOrder();
        cancelTradeOrder.setClientOrderId(tradePlaceOrderResponse.getClientOrderId());
        logger.info("cancelOrderRequest: {}", (Object)cancelTradeOrder);
        TradeOrderResponse tradeCancelOrderResponse = apiService.cancelOrder(accountId, cancelTradeOrder);
        logger.info("cancelOrderResponse: {}", (Object)tradeCancelOrderResponse);
        TradeClientV2.doSleep();
        List listOrdersResponse = apiService.listOrders(accountId, Integer.valueOf(10), "2024-09-25", null, null);
        logger.info("listOrdersResponse: {}", (Object)listOrdersResponse);
        List openOrdersResponse = apiService.openOrders(accountId, Integer.valueOf(10), null);
        logger.info("openOrdersResponse: {}", (Object)openOrdersResponse);
        OrderHistory orderDetailResponse = apiService.getOrderDetails(accountId, clientOrderId);
        logger.info("orderDetailResponse: {}", (Object)orderDetailResponse);
        String optionClientOrderId = GUID.get();
        OptionOrderItemLeg optionOrderItemLeg = new OptionOrderItemLeg();
        optionOrderItemLeg.setSide(OrderSide.BUY.name());
        optionOrderItemLeg.setQuantity("1");
        optionOrderItemLeg.setSymbol("AAPL");
        optionOrderItemLeg.setStrikePrice("250");
        optionOrderItemLeg.setInitExpDate("2025-12-19");
        optionOrderItemLeg.setInstrumentType(InstrumentSuperType.OPTION.name());
        optionOrderItemLeg.setOptionType(OptionType.CALL.name());
        optionOrderItemLeg.setMarket(Markets.US.name());
        ArrayList<OptionOrderItemLeg> optionOrderItemLegList = new ArrayList<OptionOrderItemLeg>();
        optionOrderItemLegList.add(optionOrderItemLeg);
        OptionOrderItem optionOrderItem = new OptionOrderItem();
        optionOrderItem.setClientOrderId(optionClientOrderId);
        optionOrderItem.setComboType(ComboType.NORMAL.name());
        optionOrderItem.setOptionStrategy(OptionStrategy.SINGLE.name());
        optionOrderItem.setSide(OrderSide.BUY.name());
        optionOrderItem.setOrderType(OrderType.LIMIT.name());
        optionOrderItem.setTimeInForce(OrderTIF.GTC.name());
        optionOrderItem.setLimitPrice("2");
        optionOrderItem.setQuantity("1");
        optionOrderItem.setEntrustType(EntrustType.QTY.name());
        optionOrderItem.setOrders(optionOrderItemLegList);
        ArrayList<OptionOrderItem> optionOrderItemList = new ArrayList<OptionOrderItem>();
        optionOrderItemList.add(optionOrderItem);
        OptionOrder optionOrder = new OptionOrder();
        optionOrder.setNewOrders(optionOrderItemList);
        logger.info("previewOptionRequest: {}", (Object)optionOrder);
        PreviewOrderResponse previewOptionResponse = apiService.previewOption(accountId, optionOrder);
        logger.info("previewOptionResponse: {}", (Object)previewOptionResponse);
        logger.info("placeOptionRequest: {}", (Object)optionOrder);
        HashMap<String, String> optionCustomHeadersMap = new HashMap<String, String>();
        optionCustomHeadersMap.put("category", Category.US_OPTION.name());
        apiService.addCustomHeaders(optionCustomHeadersMap);
        TradeOrderResponse placeOptionResponse = apiService.placeOption(accountId, optionOrder);
        apiService.removeCustomHeaders();
        logger.info("placeOptionResponse: {}", (Object)placeOptionResponse);
        TradeClientV2.doSleep();
        OptionOrderItemLeg optionReplaceItemLeg = new OptionOrderItemLeg();
        optionReplaceItemLeg.setQuantity("2");
        optionReplaceItemLeg.setClientOrderId(optionOrderItem.getClientOrderId());
        ArrayList<OptionOrderItemLeg> optionReplaceItemLegList = new ArrayList<OptionOrderItemLeg>();
        optionReplaceItemLegList.add(optionReplaceItemLeg);
        OptionOrderItem optionReplaceItem = new OptionOrderItem();
        optionReplaceItem.setClientOrderId(optionOrderItem.getClientOrderId());
        optionReplaceItem.setLimitPrice("3");
        optionReplaceItem.setQuantity("2");
        optionReplaceItem.setOrders(optionReplaceItemLegList);
        ArrayList<OptionOrderItem> optionReplaceItemList = new ArrayList<OptionOrderItem>();
        optionReplaceItemList.add(optionReplaceItem);
        OptionOrder optionReplace = new OptionOrder();
        optionReplace.setModifyOrders(optionReplaceItemList);
        logger.info("replaceOptionRequest: {}", (Object)optionReplace);
        TradeOrderResponse replaceOptionResponse = apiService.replaceOption(accountId, optionReplace);
        logger.info("replaceOptionResponse: {}", (Object)replaceOptionResponse);
        TradeClientV2.doSleep();
        OptionOrder cancelTradeOption = new OptionOrder();
        cancelTradeOption.setClientOrderId(optionOrderItem.getClientOrderId());
        logger.info("cancelOptionRequest: {}", (Object)cancelTradeOption);
        TradeOrderResponse cancelOptionResponse = apiService.cancelOption(accountId, cancelTradeOption);
        logger.info("cancelOptionResponse: {}", (Object)cancelOptionResponse);
        TradeClientV2.doSleep();
        listOrdersResponse = apiService.listOrders(accountId, Integer.valueOf(10), "2024-09-25", null, null);
        logger.info("listOrdersResponse: {}", (Object)listOrdersResponse);
        OrderHistory optionDetailResponse = apiService.getOrderDetails(accountId, optionOrderItem.getClientOrderId());
        logger.info("optionDetailResponse: {}", (Object)optionDetailResponse);
    }

    private static void doSleep() throws InterruptedException {
        long ticker = 5L;
        int waitTime = 1;
        long startTime = System.currentTimeMillis();
        while (true) {
            long elapsed;
            if ((elapsed = (System.currentTimeMillis() - startTime) / 1000L) >= ticker) break;
            logger.info("Waiting {} seconds before starting the next step... (elapsed {}s / {}s)", new Object[]{waitTime, elapsed, ticker});
            Thread.sleep((long)waitTime * 1000L);
        }
        logger.info("Wait completed, start next step...");
    }
}

