/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.samples.trade;

import com.google.gson.reflect.TypeToken;
import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.execption.ServerException;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.serialize.JsonSerializer;
import com.webull.openapi.trade.events.subscribe.ISubscription;
import com.webull.openapi.trade.events.subscribe.ITradeEventClient;
import com.webull.openapi.trade.events.subscribe.message.EventType;
import com.webull.openapi.trade.events.subscribe.message.SubscribeRequest;
import com.webull.openapi.trade.events.subscribe.message.SubscribeResponse;
import java.lang.reflect.Type;
import java.util.Map;

public class TradeEventsClient {
    private static final Logger logger = LoggerFactory.getLogger(TradeEventsClient.class);

    public static void main(String[] args) {
        try (ITradeEventClient client = ITradeEventClient.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId("<your_region_id>").onMessage(TradeEventsClient::handleEventMessage).build();){
            SubscribeRequest request = new SubscribeRequest(new String[]{"<your_account_id>"});
            ISubscription subscription = client.subscribe(request);
            subscription.blockingAwait();
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }

    private static void handleEventMessage(SubscribeResponse response) {
        if ("application/json".equals(response.getContentType())) {
            Map payload = (Map)JsonSerializer.fromJson((String)response.getPayload(), (Type)new TypeToken<Map<String, String>>(){}.getType());
            if (EventType.Order.getCode() == response.getEventType() || EventType.Position.getCode() == response.getEventType()) {
                logger.info("----request_id:{}----", payload.get("request_id"));
                logger.info((String)payload.get("account_id"));
                logger.info((String)payload.get("client_order_id"));
                logger.info((String)payload.get("order_status"));
            }
        }
    }
}

