/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.samples.trade;

import com.webull.openapi.core.common.dict.ComboType;
import com.webull.openapi.core.common.dict.EntrustType;
import com.webull.openapi.core.common.dict.InstrumentSuperType;
import com.webull.openapi.core.common.dict.Markets;
import com.webull.openapi.core.common.dict.OptionStrategy;
import com.webull.openapi.core.common.dict.OptionType;
import com.webull.openapi.core.common.dict.OrderSide;
import com.webull.openapi.core.common.dict.OrderTIF;
import com.webull.openapi.core.common.dict.OrderType;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.utils.CollectionUtils;
import com.webull.openapi.core.utils.GUID;
import com.webull.openapi.core.utils.StringUtils;
import com.webull.openapi.trade.request.v3.OptionOrderItemLeg;
import com.webull.openapi.trade.request.v3.TradeOrder;
import com.webull.openapi.trade.request.v3.TradeOrderItem;
import com.webull.openapi.trade.response.NOrderItem;
import com.webull.openapi.trade.response.NOrderItemLeg;
import com.webull.openapi.trade.response.v3.Account;
import com.webull.openapi.trade.response.v3.AccountBalanceInfo;
import com.webull.openapi.trade.response.v3.OrderHistory;
import com.webull.openapi.trade.response.v3.PreviewOrderResponse;
import com.webull.openapi.trade.response.v3.TradeBatchPlaceResponse;
import com.webull.openapi.trade.response.v3.TradeOrderResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TradeClientV3 {
    private static final Logger logger = LoggerFactory.getLogger(TradeClientV3.class);
    private static final String FUTURES = "FUTURES";
    private static final String CRYPTO = "CRYPTO";

    public static void main(String[] args) throws InterruptedException {
        HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId("<your_region_id>").build();
        com.webull.openapi.trade.TradeClientV3 apiService = new com.webull.openapi.trade.TradeClientV3(apiConfig);
        AccountIds accountIds = TradeClientV3.initAccount(apiService);
        if (CollectionUtils.isNotEmpty(accountIds.getSecurityAccountIds())) {
            TradeClientV3.runEquityNormalOrderExample(apiService, accountIds.getSecurityAccountIds().get(0));
            TradeClientV3.runEquityBatchOrderExample(apiService, accountIds.getSecurityAccountIds().get(0));
            TradeClientV3.runEquityComboOrderExample(apiService, accountIds.getSecurityAccountIds().get(0));
            TradeClientV3.runOptionOrderExample(apiService, accountIds.getSecurityAccountIds().get(0));
        }
        if (CollectionUtils.isNotEmpty(accountIds.getCryptoAccountIds())) {
            TradeClientV3.runCryptoOrderExample(apiService, accountIds.getCryptoAccountIds().get(0));
        }
        if (CollectionUtils.isNotEmpty(accountIds.getFuturesAccountIds())) {
            TradeClientV3.runFutureOrderExample(apiService, accountIds.getFuturesAccountIds().get(0));
        }
    }

    private static AccountIds initAccount(com.webull.openapi.trade.TradeClientV3 apiService) {
        List accounts = apiService.listAccount();
        logger.info("Accounts: {}", (Object)accounts);
        AccountIds accountIds = new AccountIds();
        if (CollectionUtils.isNotEmpty((Collection)accounts)) {
            for (Account account : accounts) {
                if (account == null || StringUtils.isBlank((CharSequence)account.getAccountClass())) continue;
                String accountClass = account.getAccountClass();
                String accountId = account.getAccountId();
                if (FUTURES.equalsIgnoreCase(accountClass)) {
                    accountIds.setFuturesAccountId(accountId);
                } else if (CRYPTO.equalsIgnoreCase(accountClass)) {
                    accountIds.setCryptoAccountId(accountId);
                } else {
                    accountIds.setSecuritiesAccountId(accountId);
                }
                AccountBalanceInfo accountBalanceInfo = apiService.balanceAccount(accountId);
                logger.info("accountBalance: {}", (Object)accountBalanceInfo);
                List accountPositionsInfos = apiService.positionsAccount(accountId);
                logger.info("accountPositions: {}", (Object)accountPositionsInfos);
            }
        }
        return accountIds;
    }

    private static void runEquityBatchOrderExample(com.webull.openapi.trade.TradeClientV3 apiService, String accountId) throws InterruptedException {
        TradeOrder newBatchOrder = new TradeOrder();
        ArrayList<TradeOrderItem> batchOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem normalEquityOrder = new TradeOrderItem();
        normalEquityOrder.setClientOrderId(GUID.get());
        normalEquityOrder.setComboType(ComboType.NORMAL.name());
        normalEquityOrder.setSymbol("AAPL");
        normalEquityOrder.setInstrumentType(InstrumentSuperType.EQUITY.name());
        normalEquityOrder.setMarket(Markets.US.name());
        normalEquityOrder.setOrderType(OrderType.LIMIT.name());
        normalEquityOrder.setQuantity("1");
        normalEquityOrder.setLimitPrice("280");
        normalEquityOrder.setSupportTradingSession("CORE");
        normalEquityOrder.setSide(OrderSide.BUY.name());
        normalEquityOrder.setTimeInForce(OrderTIF.DAY.name());
        normalEquityOrder.setEntrustType(EntrustType.QTY.name());
        batchOrders.add(normalEquityOrder);
        newBatchOrder.setBatchOrders(batchOrders);
        TradeBatchPlaceResponse placeNormalEquityResponse = apiService.batchPlaceOrder(accountId, newBatchOrder);
        logger.info("batchPlaceNormalEquityResponse:{}", (Object)placeNormalEquityResponse);
    }

    private static void runEquityNormalOrderExample(com.webull.openapi.trade.TradeClientV3 apiService, String accountId) throws InterruptedException {
        TradeOrder newNormalEquityOrder = new TradeOrder();
        ArrayList<TradeOrderItem> newNormalEquityOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem normalEquityOrder = new TradeOrderItem();
        newNormalEquityOrders.add(normalEquityOrder);
        normalEquityOrder.setClientOrderId(GUID.get());
        normalEquityOrder.setComboType(ComboType.NORMAL.name());
        normalEquityOrder.setSymbol("AAPL");
        normalEquityOrder.setInstrumentType(InstrumentSuperType.EQUITY.name());
        normalEquityOrder.setMarket(Markets.US.name());
        normalEquityOrder.setOrderType(OrderType.LIMIT.name());
        normalEquityOrder.setQuantity("1");
        normalEquityOrder.setLimitPrice("280");
        normalEquityOrder.setSupportTradingSession("N");
        normalEquityOrder.setSide(OrderSide.BUY.name());
        normalEquityOrder.setTimeInForce(OrderTIF.GTC.name());
        normalEquityOrder.setEntrustType(EntrustType.QTY.name());
        newNormalEquityOrder.setNewOrders(newNormalEquityOrders);
        PreviewOrderResponse previewNormalEquityResponse = apiService.previewOrder(accountId, newNormalEquityOrder);
        logger.info("previewNormalEquityResponse: {}", (Object)previewNormalEquityResponse);
        TradeOrderResponse placeNormalEquityResponse = apiService.placeOrder(accountId, newNormalEquityOrder);
        logger.info("placeNormalEquityResponse: {}", (Object)placeNormalEquityResponse);
        TradeClientV3.doSleep();
        TradeOrder replaceNormalEquityOrder = new TradeOrder();
        ArrayList<TradeOrderItem> replaceNormalEquityOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem replaceEquityOrder = new TradeOrderItem();
        replaceEquityOrder.setClientOrderId(normalEquityOrder.getClientOrderId());
        replaceEquityOrder.setLimitPrice("275");
        replaceEquityOrder.setQuantity("2");
        replaceNormalEquityOrders.add(replaceEquityOrder);
        replaceNormalEquityOrder.setModifyOrders(replaceNormalEquityOrders);
        TradeOrderResponse replaceNormalEquityResponse = apiService.replaceOrder(accountId, replaceNormalEquityOrder);
        logger.info("replaceNormalEquityResponse: {}", (Object)replaceNormalEquityResponse);
        TradeClientV3.doSleep();
        TradeOrder cancelNormalEquityOrder = new TradeOrder();
        cancelNormalEquityOrder.setClientOrderId(normalEquityOrder.getClientOrderId());
        TradeOrderResponse cancelNormalEquityResponse = apiService.cancelOrder(accountId, cancelNormalEquityOrder);
        logger.info("cancelNormalEquityResponse: {}", (Object)cancelNormalEquityResponse);
        List listOrdersResponse = apiService.listOrders(accountId, Integer.valueOf(10), null, null, null);
        logger.info("listOrdersResponse: {}", (Object)listOrdersResponse);
        List openOrdersResponse = apiService.openOrders(accountId, Integer.valueOf(10), null);
        logger.info("openOrdersResponse: {}", (Object)openOrdersResponse);
        OrderHistory orderDetailResponse = apiService.getOrderDetails(accountId, normalEquityOrder.getClientOrderId());
        logger.info("orderDetailResponse: {}", (Object)orderDetailResponse);
    }

    private static void runEquityComboOrderExample(com.webull.openapi.trade.TradeClientV3 apiService, String accountId) throws InterruptedException {
        TradeOrder newComboEquityOrder = new TradeOrder();
        ArrayList<TradeOrderItem> newComboEquityOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem comboEquityMaster = new TradeOrderItem();
        comboEquityMaster.setClientOrderId(GUID.get());
        comboEquityMaster.setComboType(ComboType.MASTER.name());
        comboEquityMaster.setSymbol("F");
        comboEquityMaster.setInstrumentType(InstrumentSuperType.EQUITY.name());
        comboEquityMaster.setMarket(Markets.US.name());
        comboEquityMaster.setOrderType(OrderType.LIMIT.name());
        comboEquityMaster.setQuantity("1");
        comboEquityMaster.setLimitPrice("10.5");
        comboEquityMaster.setSupportTradingSession("N");
        comboEquityMaster.setSide(OrderSide.BUY.name());
        comboEquityMaster.setTimeInForce(OrderTIF.DAY.name());
        comboEquityMaster.setEntrustType(EntrustType.QTY.name());
        TradeOrderItem comboEquityStopProfit = new TradeOrderItem();
        comboEquityStopProfit.setClientOrderId(GUID.get());
        comboEquityStopProfit.setComboType(ComboType.STOP_PROFIT.name());
        comboEquityStopProfit.setSymbol("F");
        comboEquityStopProfit.setInstrumentType(InstrumentSuperType.EQUITY.name());
        comboEquityStopProfit.setMarket(Markets.US.name());
        comboEquityStopProfit.setOrderType(OrderType.LIMIT.name());
        comboEquityStopProfit.setQuantity("1");
        comboEquityStopProfit.setLimitPrice("11.5");
        comboEquityStopProfit.setSupportTradingSession("N");
        comboEquityStopProfit.setSide(OrderSide.SELL.name());
        comboEquityStopProfit.setTimeInForce(OrderTIF.DAY.name());
        comboEquityStopProfit.setEntrustType(EntrustType.QTY.name());
        TradeOrderItem comboEquityStopLoss = new TradeOrderItem();
        comboEquityStopLoss.setClientOrderId(GUID.get());
        comboEquityStopLoss.setComboType(ComboType.STOP_LOSS.name());
        comboEquityStopLoss.setSymbol("F");
        comboEquityStopLoss.setInstrumentType(InstrumentSuperType.EQUITY.name());
        comboEquityStopLoss.setMarket(Markets.US.name());
        comboEquityStopLoss.setOrderType(OrderType.STOP_LOSS.name());
        comboEquityStopLoss.setQuantity("1");
        comboEquityStopLoss.setStopPrice("9.5");
        comboEquityStopLoss.setSupportTradingSession("N");
        comboEquityStopLoss.setSide(OrderSide.SELL.name());
        comboEquityStopLoss.setTimeInForce(OrderTIF.DAY.name());
        comboEquityStopLoss.setEntrustType(EntrustType.QTY.name());
        newComboEquityOrders.add(comboEquityMaster);
        newComboEquityOrders.add(comboEquityStopProfit);
        newComboEquityOrders.add(comboEquityStopLoss);
        newComboEquityOrder.setNewOrders(newComboEquityOrders);
        PreviewOrderResponse previewComboEquityResponse = apiService.previewOrder(accountId, newComboEquityOrder);
        logger.info("previewComboEquityResponse: {}", (Object)previewComboEquityResponse);
        TradeOrderResponse placeComboEquityResponse = apiService.placeOrder(accountId, newComboEquityOrder);
        logger.info("placeComboEquityResponse: {}", (Object)placeComboEquityResponse);
        TradeClientV3.doSleep();
        TradeOrder replaceComboEquityOrder = new TradeOrder();
        ArrayList<TradeOrderItem> replaceComboEquityOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem replaceEquityMaster = new TradeOrderItem();
        replaceEquityMaster.setClientOrderId(comboEquityMaster.getClientOrderId());
        replaceEquityMaster.setLimitPrice("10.8");
        replaceEquityMaster.setQuantity("2");
        TradeOrderItem replaceEquityStopProfit = new TradeOrderItem();
        replaceEquityStopProfit.setClientOrderId(comboEquityStopProfit.getClientOrderId());
        replaceEquityStopProfit.setLimitPrice("11.8");
        replaceEquityStopProfit.setQuantity("2");
        TradeOrderItem replaceEquityStopLoss = new TradeOrderItem();
        replaceEquityStopLoss.setClientOrderId(comboEquityStopLoss.getClientOrderId());
        replaceEquityStopLoss.setStopPrice("9.8");
        replaceEquityStopLoss.setQuantity("2");
        replaceComboEquityOrders.add(replaceEquityMaster);
        replaceComboEquityOrders.add(replaceEquityStopProfit);
        replaceComboEquityOrders.add(replaceEquityStopLoss);
        replaceComboEquityOrder.setModifyOrders(replaceComboEquityOrders);
        TradeOrderResponse replaceComboEquityResponse = apiService.replaceOrder(accountId, replaceComboEquityOrder);
        logger.info("replaceComboEquityResponse: {}", (Object)replaceComboEquityResponse);
        TradeClientV3.doSleep();
        TradeOrder cancelComboEquityOrder = new TradeOrder();
        cancelComboEquityOrder.setClientOrderId(comboEquityMaster.getClientOrderId());
        TradeOrderResponse cancelComboEquityResponse = apiService.cancelOrder(accountId, cancelComboEquityOrder);
        logger.info("cancelComboEquityResponse: {}", (Object)cancelComboEquityResponse);
        List listComboOrdersResponse = apiService.listOrders(accountId, Integer.valueOf(10), null, null, null);
        logger.info("listComboOrdersResponse: {}", (Object)listComboOrdersResponse);
        OrderHistory masterOrderDetailResponse = apiService.getOrderDetails(accountId, comboEquityMaster.getClientOrderId());
        logger.info("masterOrderDetailResponse: {}", (Object)masterOrderDetailResponse);
    }

    private static void runOptionOrderExample(com.webull.openapi.trade.TradeClientV3 apiService, String accountId) throws InterruptedException {
        OptionOrderItemLeg normalOptionOrderLeg = new OptionOrderItemLeg();
        normalOptionOrderLeg.setSide(OrderSide.BUY.name());
        normalOptionOrderLeg.setQuantity("1");
        normalOptionOrderLeg.setSymbol("AAPL");
        normalOptionOrderLeg.setStrikePrice("250");
        normalOptionOrderLeg.setOptionExpireDate("2025-12-19");
        normalOptionOrderLeg.setInstrumentType(InstrumentSuperType.OPTION.name());
        normalOptionOrderLeg.setOptionType(OptionType.CALL.name());
        normalOptionOrderLeg.setMarket(Markets.US.name());
        ArrayList<OptionOrderItemLeg> normalOtionOrderLegList = new ArrayList<OptionOrderItemLeg>();
        normalOtionOrderLegList.add(normalOptionOrderLeg);
        TradeOrderItem normalOptionOrder = new TradeOrderItem();
        normalOptionOrder.setClientOrderId(GUID.get());
        normalOptionOrder.setComboType(ComboType.NORMAL.name());
        normalOptionOrder.setOptionStrategy(OptionStrategy.SINGLE.name());
        normalOptionOrder.setSide(OrderSide.BUY.name());
        normalOptionOrder.setOrderType(OrderType.LIMIT.name());
        normalOptionOrder.setTimeInForce(OrderTIF.GTC.name());
        normalOptionOrder.setLimitPrice("20.5");
        normalOptionOrder.setQuantity("1");
        normalOptionOrder.setEntrustType(EntrustType.QTY.name());
        normalOptionOrder.setLegs(normalOtionOrderLegList);
        ArrayList<TradeOrderItem> newNormalOptionOrders = new ArrayList<TradeOrderItem>();
        newNormalOptionOrders.add(normalOptionOrder);
        TradeOrder newNormalOptionOrder = new TradeOrder();
        newNormalOptionOrder.setNewOrders(newNormalOptionOrders);
        logger.info("previewNormalOptionRequest: {}", (Object)newNormalOptionOrder);
        PreviewOrderResponse previewNormalOptionResponse = apiService.previewOrder(accountId, newNormalOptionOrder);
        logger.info("previewNormalOptionResponse: {}", (Object)previewNormalOptionResponse);
        logger.info("placeNormalOptionRequest: {}", (Object)newNormalOptionOrder);
        TradeOrderResponse placeNormalOptionResponse = apiService.placeOrder(accountId, newNormalOptionOrder);
        logger.info("placeNormalOptionResponse: {}", (Object)placeNormalOptionResponse);
        TradeClientV3.doSleep();
        OrderHistory orderDetailResponse = apiService.getOrderDetails(accountId, normalOptionOrder.getClientOrderId());
        logger.info("orderDetailResponse: {}", (Object)orderDetailResponse);
        String legId = null;
        if (Objects.nonNull(orderDetailResponse) && CollectionUtils.isNotEmpty((Collection)orderDetailResponse.getOrders()) && Objects.nonNull(orderDetailResponse.getOrders().get(0)) && CollectionUtils.isNotEmpty((Collection)((NOrderItem)orderDetailResponse.getOrders().get(0)).getLegs()) && Objects.nonNull(((NOrderItem)orderDetailResponse.getOrders().get(0)).getLegs().get(0))) {
            legId = ((NOrderItemLeg)((NOrderItem)orderDetailResponse.getOrders().get(0)).getLegs().get(0)).getId();
        }
        logger.info("orderDetailResponse leg id: {}", legId);
        if (StringUtils.isNotBlank(legId)) {
            OptionOrderItemLeg replaceOptionOrderLeg = new OptionOrderItemLeg();
            replaceOptionOrderLeg.setQuantity("2");
            replaceOptionOrderLeg.setId(legId);
            ArrayList<OptionOrderItemLeg> replaceOptionOrderLegs = new ArrayList<OptionOrderItemLeg>();
            replaceOptionOrderLegs.add(replaceOptionOrderLeg);
            TradeOrderItem replaceOptionOrder = new TradeOrderItem();
            replaceOptionOrder.setClientOrderId(normalOptionOrder.getClientOrderId());
            replaceOptionOrder.setLimitPrice("20");
            replaceOptionOrder.setQuantity("2");
            replaceOptionOrder.setLegs(replaceOptionOrderLegs);
            ArrayList<TradeOrderItem> replaceNormalOptionOrders = new ArrayList<TradeOrderItem>();
            replaceNormalOptionOrders.add(replaceOptionOrder);
            TradeOrder replaceNormalOptionOrder = new TradeOrder();
            replaceNormalOptionOrder.setModifyOrders(replaceNormalOptionOrders);
            logger.info("replaceNormalOptionRequest: {}", (Object)replaceNormalOptionOrder);
            TradeOrderResponse replaceNormalOptionResponse = apiService.replaceOrder(accountId, replaceNormalOptionOrder);
            logger.info("replaceNormalOptionResponse: {}", (Object)replaceNormalOptionResponse);
            TradeClientV3.doSleep();
        }
        TradeOrder cancelNormalOptionOrder = new TradeOrder();
        cancelNormalOptionOrder.setClientOrderId(normalOptionOrder.getClientOrderId());
        logger.info("cancelNormalOptionRequest: {}", (Object)cancelNormalOptionOrder);
        TradeOrderResponse cancelNormalOptionResponse = apiService.cancelOrder(accountId, cancelNormalOptionOrder);
        logger.info("cancelNormalOptionResponse: {}", (Object)cancelNormalOptionResponse);
        List optionHistoryResponse = apiService.listOrders(accountId, Integer.valueOf(10), null, null, null);
        logger.info("optionHistoryResponse: {}", (Object)optionHistoryResponse);
        OrderHistory optionDetailResponse = apiService.getOrderDetails(accountId, normalOptionOrder.getClientOrderId());
        logger.info("optionDetailResponse: {}", (Object)optionDetailResponse);
    }

    private static void runCryptoOrderExample(com.webull.openapi.trade.TradeClientV3 apiService, String accountId) throws InterruptedException {
        TradeOrder newNormalCryptoOrder = new TradeOrder();
        ArrayList<TradeOrderItem> newNormalCryptoOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem normalCryptoOrder = new TradeOrderItem();
        newNormalCryptoOrders.add(normalCryptoOrder);
        normalCryptoOrder.setClientOrderId(GUID.get());
        normalCryptoOrder.setComboType(ComboType.NORMAL.name());
        normalCryptoOrder.setSymbol("BTCUSD");
        normalCryptoOrder.setInstrumentType(InstrumentSuperType.CRYPTO.name());
        normalCryptoOrder.setMarket(Markets.US.name());
        normalCryptoOrder.setOrderType(OrderType.LIMIT.name());
        normalCryptoOrder.setQuantity("1");
        normalCryptoOrder.setLimitPrice("80000");
        normalCryptoOrder.setSide(OrderSide.BUY.name());
        normalCryptoOrder.setTimeInForce(OrderTIF.DAY.name());
        normalCryptoOrder.setEntrustType(EntrustType.QTY.name());
        newNormalCryptoOrder.setNewOrders(newNormalCryptoOrders);
        TradeOrderResponse placeNormalCryptoResponse = apiService.placeOrder(accountId, newNormalCryptoOrder);
        logger.info("placeNormalCryptoResponse: {}", (Object)placeNormalCryptoResponse);
        TradeClientV3.doSleep();
        TradeOrder cancelNormalCryptoOrder = new TradeOrder();
        cancelNormalCryptoOrder.setClientOrderId(placeNormalCryptoResponse.getClientOrderId());
        TradeOrderResponse cancelNormalCryptoResponse = apiService.cancelOrder(accountId, cancelNormalCryptoOrder);
        logger.info("cancelNormalCryptoResponse: {}", (Object)cancelNormalCryptoResponse);
        List listOrdersResponse = apiService.listOrders(accountId, Integer.valueOf(10), null, null, null);
        logger.info("listOrdersResponse: {}", (Object)listOrdersResponse);
        List openOrdersResponse = apiService.openOrders(accountId, Integer.valueOf(10), null);
        logger.info("openOrdersResponse: {}", (Object)openOrdersResponse);
        OrderHistory orderDetailResponse = apiService.getOrderDetails(accountId, normalCryptoOrder.getClientOrderId());
        logger.info("orderDetailResponse: {}", (Object)orderDetailResponse);
    }

    private static void runFutureOrderExample(com.webull.openapi.trade.TradeClientV3 apiService, String accountId) {
        TradeOrder newFuturesOrder = new TradeOrder();
        ArrayList<TradeOrderItem> newFuturesOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem normalFuturesOrder = new TradeOrderItem();
        newFuturesOrders.add(normalFuturesOrder);
        normalFuturesOrder.setClientOrderId(GUID.get());
        normalFuturesOrder.setComboType(ComboType.NORMAL.name());
        normalFuturesOrder.setSymbol("ESZ5");
        normalFuturesOrder.setInstrumentType(InstrumentSuperType.FUTURES.name());
        normalFuturesOrder.setMarket(Markets.US.name());
        normalFuturesOrder.setOrderType(OrderType.LIMIT.name());
        normalFuturesOrder.setQuantity("1");
        normalFuturesOrder.setLimitPrice("46000");
        normalFuturesOrder.setSide(OrderSide.BUY.name());
        normalFuturesOrder.setTimeInForce(OrderTIF.DAY.name());
        normalFuturesOrder.setEntrustType(EntrustType.QTY.name());
        newFuturesOrder.setNewOrders(newFuturesOrders);
        logger.info("newFuturesOrder: {}", (Object)newFuturesOrder);
        PreviewOrderResponse previewFuturesResponse = apiService.previewOrder(accountId, newFuturesOrder);
        logger.info("previewFuturesResponse: {}", (Object)previewFuturesResponse);
        TradeOrderResponse placeFuturesResponse = apiService.placeOrder(accountId, newFuturesOrder);
        logger.info("placeFuturesResponse: {}", (Object)placeFuturesResponse);
        TradeOrder replaceFuturesOrder = new TradeOrder();
        ArrayList<TradeOrderItem> replaceFuturesOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem replaceFuturesOrderItem = new TradeOrderItem();
        replaceFuturesOrders.add(replaceFuturesOrderItem);
        replaceFuturesOrderItem.setClientOrderId(normalFuturesOrder.getClientOrderId());
        replaceFuturesOrderItem.setLimitPrice("46000");
        replaceFuturesOrderItem.setQuantity("2");
        replaceFuturesOrder.setModifyOrders(replaceFuturesOrders);
        logger.info("replaceFuturesOrder: {}", (Object)replaceFuturesOrder);
        TradeOrderResponse replaceFuturesResponse = apiService.replaceOrder(accountId, replaceFuturesOrder);
        logger.info("replaceFuturesResponse: {}", (Object)replaceFuturesResponse);
        TradeOrder cancelFuturesOrder = new TradeOrder();
        cancelFuturesOrder.setClientOrderId(normalFuturesOrder.getClientOrderId());
        TradeOrderResponse tradeOrderResponse = apiService.cancelOrder(accountId, cancelFuturesOrder);
        logger.info("cancelNormalFuturesResponse: {}", (Object)tradeOrderResponse);
        List listOrdersResponse = apiService.listOrders(accountId, Integer.valueOf(10), null, null, null);
        logger.info("listOrdersResponse: {}", (Object)listOrdersResponse);
        List openOrdersResponse = apiService.openOrders(accountId, Integer.valueOf(10), null);
        logger.info("openOrdersResponse: {}", (Object)openOrdersResponse);
        OrderHistory orderDetailResponse = apiService.getOrderDetails(accountId, normalFuturesOrder.getClientOrderId());
        logger.info("orderDetailResponse: {}", (Object)orderDetailResponse);
    }

    private static void doSleep() throws InterruptedException {
        int totalSeconds = 5;
        boolean intervalSeconds = true;
        for (int elapsed = 1; elapsed <= 5; ++elapsed) {
            Thread.sleep(1000L);
            logger.info("Waiting {} seconds before starting the next step... (elapsed {}s / {}s)", new Object[]{1, elapsed, 5});
        }
        logger.info("Wait completed, start next step...");
    }

    public static class AccountIds {
        private final List<String> securityAccountIds = new ArrayList<String>();
        private final List<String> futuresAccountIds = new ArrayList<String>();
        private final List<String> cryptoAccountIds = new ArrayList<String>();

        public List<String> getSecurityAccountIds() {
            return this.securityAccountIds;
        }

        public void setSecuritiesAccountId(String accountId) {
            this.securityAccountIds.add(accountId);
        }

        public List<String> getFuturesAccountIds() {
            return this.futuresAccountIds;
        }

        public void setFuturesAccountId(String accountId) {
            this.futuresAccountIds.add(accountId);
        }

        public List<String> getCryptoAccountIds() {
            return this.cryptoAccountIds;
        }

        public void setCryptoAccountId(String accountId) {
            this.cryptoAccountIds.add(accountId);
        }
    }
}

