/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.samples.data;

import com.webull.openapi.core.common.dict.Category;
import com.webull.openapi.core.common.dict.SubscribeType;
import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.execption.ServerException;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.serialize.JsonSerializer;
import com.webull.openapi.core.utils.GUID;
import com.webull.openapi.data.quotes.subsribe.IDataStreamingClient;
import com.webull.openapi.data.quotes.subsribe.message.MarketData;
import java.util.HashSet;

public class DataStreamingClient {
    private static final Logger logger = LoggerFactory.getLogger(DataStreamingClient.class);

    public static void main(String[] args) {
        HashSet<String> symbols = new HashSet<String>();
        symbols.add("AAPL");
        HashSet<String> subTypes = new HashSet<String>();
        subTypes.add(SubscribeType.SNAPSHOT.name());
        subTypes.add(SubscribeType.QUOTE.name());
        subTypes.add(SubscribeType.TICK.name());
        try (IDataStreamingClient client = IDataStreamingClient.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").sessionId(GUID.get()).regionId("<your_region_id>").onMessage(DataStreamingClient::handleMarketData).addSubscription(symbols, Category.US_STOCK.name(), subTypes, "1", Boolean.valueOf(false)).build();){
            DataStreamingClient.subscribeBlocking(client);
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }

    private static void handleMarketData(MarketData marketData) {
        logger.info("Received market data: {}", (Object)JsonSerializer.toJson((Object)marketData));
    }

    private static void subscribeBlocking(IDataStreamingClient client) {
        client.connectBlocking();
        logger.info("Connect completed.");
        client.subscribeBlocking();
        logger.info("Subscribe completed.");
    }
}

