/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.samples.order;

import com.webull.openapi.core.common.dict.ComboType;
import com.webull.openapi.core.common.dict.EntrustType;
import com.webull.openapi.core.common.dict.InstrumentSuperType;
import com.webull.openapi.core.common.dict.Markets;
import com.webull.openapi.core.common.dict.OptionStrategy;
import com.webull.openapi.core.common.dict.OptionType;
import com.webull.openapi.core.common.dict.OrderSide;
import com.webull.openapi.core.common.dict.OrderTIF;
import com.webull.openapi.core.common.dict.OrderType;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.utils.GUID;
import com.webull.openapi.trade.TradeClientV2;
import com.webull.openapi.trade.request.v2.OptionOrder;
import com.webull.openapi.trade.request.v2.OptionOrderItem;
import com.webull.openapi.trade.request.v2.OptionOrderItemLeg;
import com.webull.openapi.trade.response.v2.OrderHistory;
import com.webull.openapi.trade.response.v2.TradeOrderResponse;
import java.util.ArrayList;

public class OrderOptionTradeClient {
    private static final Logger logger = LoggerFactory.getLogger(OrderOptionTradeClient.class);

    public static void main(String[] args) {
        OrderOptionTradeClient orderOptionTradeClient = new OrderOptionTradeClient();
        HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId("<your_region_id>").endpoint("<api_endpoint>").build();
        TradeClientV2 apiService = new TradeClientV2(apiConfig);
        String accountId = "#{accountId}";
        String clientOrderId = GUID.get();
        OptionOrder optionOrder = orderOptionTradeClient.buildOptionPlaceParams(clientOrderId);
        TradeOrderResponse tradeOrderResponse = apiService.placeOption(accountId, optionOrder);
        logger.info("Place option order response: {}", (Object)tradeOrderResponse);
        OrderHistory orderDetails = apiService.getOrderDetails(accountId, clientOrderId);
        logger.info("Order details response: {}", (Object)orderDetails);
        OptionOrder replaceOptionOrder = orderOptionTradeClient.buildReplaceOptionPlaceParams(clientOrderId);
        TradeOrderResponse replaceResponse = apiService.replaceOption(accountId, replaceOptionOrder);
        logger.info("Replace option order response: {}", (Object)replaceResponse);
        OrderHistory orderDetails2 = apiService.getOrderDetails(accountId, clientOrderId);
        logger.info("Order details response: {}", (Object)orderDetails2);
        OptionOrder cancelOption = new OptionOrder();
        cancelOption.setClientOrderId(clientOrderId);
        TradeOrderResponse orderResponse = apiService.cancelOption(accountId, cancelOption);
        logger.info("Option order cancel response: {}", (Object)orderResponse);
    }

    private OptionOrder buildOptionPlaceParams(String clientOrderId) {
        OptionOrderItemLeg optionOrderItemLeg = new OptionOrderItemLeg();
        optionOrderItemLeg.setSide(OrderSide.BUY.name());
        optionOrderItemLeg.setQuantity("1");
        optionOrderItemLeg.setSymbol("AAPL");
        optionOrderItemLeg.setStrikePrice("250");
        optionOrderItemLeg.setOptionExpireDate("2025-12-19");
        optionOrderItemLeg.setInstrumentType(InstrumentSuperType.OPTION.name());
        optionOrderItemLeg.setOptionType(OptionType.CALL.name());
        optionOrderItemLeg.setMarket(Markets.US.name());
        ArrayList<OptionOrderItemLeg> optionOrderItemLegList = new ArrayList<OptionOrderItemLeg>();
        optionOrderItemLegList.add(optionOrderItemLeg);
        OptionOrderItem optionOrderItem = new OptionOrderItem();
        optionOrderItem.setClientOrderId(clientOrderId);
        optionOrderItem.setComboType(ComboType.NORMAL.name());
        optionOrderItem.setOptionStrategy(OptionStrategy.SINGLE.name());
        optionOrderItem.setSide(OrderSide.BUY.name());
        optionOrderItem.setOrderType(OrderType.LIMIT.name());
        optionOrderItem.setTimeInForce(OrderTIF.GTC.name());
        optionOrderItem.setLimitPrice("20.5");
        optionOrderItem.setQuantity("1");
        optionOrderItem.setEntrustType(EntrustType.QTY.name());
        optionOrderItem.setLegs(optionOrderItemLegList);
        ArrayList<OptionOrderItem> optionOrderItemList = new ArrayList<OptionOrderItem>();
        optionOrderItemList.add(optionOrderItem);
        OptionOrder optionOrder = new OptionOrder();
        optionOrder.setNewOrders(optionOrderItemList);
        return optionOrder;
    }

    private OptionOrder buildReplaceOptionPlaceParams(String clientOrderId) {
        OptionOrder replaceOptionOrder = new OptionOrder();
        replaceOptionOrder.setClientOrderId(clientOrderId);
        ArrayList<OptionOrderItem> modifyOrders = new ArrayList<OptionOrderItem>();
        replaceOptionOrder.setModifyOrders(modifyOrders);
        OptionOrderItem optionOrderItem = new OptionOrderItem();
        modifyOrders.add(optionOrderItem);
        optionOrderItem.setClientOrderId(clientOrderId);
        optionOrderItem.setQuantity("2");
        return replaceOptionOrder;
    }
}

