/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.samples.data;

import com.webull.openapi.core.common.dict.Category;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.utils.CollectionUtils;
import com.webull.openapi.data.DataClient;
import com.webull.openapi.data.quotes.domain.EventDepth;
import com.webull.openapi.data.quotes.domain.EventInstrumentParam;
import com.webull.openapi.data.quotes.domain.EventMarket;
import com.webull.openapi.data.quotes.domain.EventSeries;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DataClientEvent {
    private static final Logger logger = LoggerFactory.getLogger(DataClientEvent.class);

    public static void main(String[] args) {
        HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId("<your_region_id>").build();
        DataClient dataClient = new DataClient(apiConfig);
        EventInstrumentParam eventInstrumentParam = new EventInstrumentParam();
        eventInstrumentParam.setCategory("ECONOMICS");
        List eventSeriesList = dataClient.getEventSeriesList(eventInstrumentParam);
        logger.info("Event Series: {}", (Object)eventSeriesList);
        if (CollectionUtils.isEmpty((Collection)eventSeriesList)) {
            return;
        }
        eventInstrumentParam.setSeriesSymbol(((EventSeries)eventSeriesList.get(0)).getSymbol());
        List eventInstrumentsList = dataClient.getEventInstrumentsList(eventInstrumentParam);
        logger.info("Event Instruments: {}", (Object)eventInstrumentsList);
        if (CollectionUtils.isEmpty((Collection)eventInstrumentsList)) {
            return;
        }
        String symbol = ((EventMarket)eventInstrumentsList.get(0)).getSymbol();
        HashSet<String> symbols = new HashSet<String>();
        symbols.add(symbol);
        List eventSnapshot = dataClient.getEventSnapshot(symbols, Category.US_EVENT.name());
        logger.info("Event Snapshot: {}", (Object)eventSnapshot);
        EventDepth eventDepth = dataClient.getEventDepth(symbol, Category.US_EVENT.name(), "10");
        logger.info("Event Depth: {}", (Object)eventDepth);
    }
}

