/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.samples.trade;

import com.webull.openapi.core.common.dict.ComboType;
import com.webull.openapi.core.common.dict.EntrustType;
import com.webull.openapi.core.common.dict.InstrumentSuperType;
import com.webull.openapi.core.common.dict.Markets;
import com.webull.openapi.core.common.dict.OrderSide;
import com.webull.openapi.core.common.dict.OrderTIF;
import com.webull.openapi.core.common.dict.OrderType;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.utils.CollectionUtils;
import com.webull.openapi.core.utils.GUID;
import com.webull.openapi.core.utils.StringUtils;
import com.webull.openapi.trade.TradeClientV3;
import com.webull.openapi.trade.request.v3.TradeOrder;
import com.webull.openapi.trade.request.v3.TradeOrderItem;
import com.webull.openapi.trade.response.v3.Account;
import com.webull.openapi.trade.response.v3.AccountBalanceInfo;
import com.webull.openapi.trade.response.v3.OrderHistory;
import com.webull.openapi.trade.response.v3.PreviewOrderResponse;
import com.webull.openapi.trade.response.v3.TradeOrderResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TradeClientV3Event {
    private static final Logger logger = LoggerFactory.getLogger(TradeClientV3Event.class);
    private static final String EVENTS_CASH = "EVENTS_CASH";

    public static void main(String[] args) throws InterruptedException {
        HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId("<your_region_id>").build();
        TradeClientV3 apiService = new TradeClientV3(apiConfig);
        List accounts = apiService.listAccount();
        String accountId = null;
        if (CollectionUtils.isNotEmpty((Collection)accounts)) {
            accountId = accounts.stream().filter(account -> account != null && StringUtils.isNotBlank((CharSequence)account.getAccountClass())).filter(account -> EVENTS_CASH.equalsIgnoreCase(account.getAccountClass())).findFirst().map(Account::getAccountId).orElse(null);
        }
        if (StringUtils.isBlank(accountId)) {
            logger.info("event accountId is null");
            return;
        }
        AccountBalanceInfo accountBalanceInfo = apiService.balanceAccount(accountId);
        logger.info("accountBalance: {}", (Object)accountBalanceInfo);
        List accountPositionsInfos = apiService.positionsAccount(accountId);
        logger.info("accountPositions: {}", (Object)accountPositionsInfos);
        TradeOrder newNormalEquityOrder = new TradeOrder();
        ArrayList<TradeOrderItem> newNormalEquityOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem normalEquityOrder = new TradeOrderItem();
        newNormalEquityOrders.add(normalEquityOrder);
        normalEquityOrder.setComboType(ComboType.NORMAL.name());
        normalEquityOrder.setClientOrderId(GUID.get());
        normalEquityOrder.setInstrumentType(InstrumentSuperType.EVENT.name());
        normalEquityOrder.setMarket(Markets.US.name());
        normalEquityOrder.setSymbol("KXFEDDECISION-26SEP-C25");
        normalEquityOrder.setOrderType(OrderType.LIMIT.name());
        normalEquityOrder.setEntrustType(EntrustType.QTY.name());
        normalEquityOrder.setTimeInForce(OrderTIF.DAY.name());
        normalEquityOrder.setSide(OrderSide.BUY.name());
        normalEquityOrder.setQuantity("1");
        normalEquityOrder.setLimitPrice("0.1");
        normalEquityOrder.setEventOutcome("yes");
        newNormalEquityOrder.setNewOrders(newNormalEquityOrders);
        PreviewOrderResponse previewNormalEquityResponse = apiService.previewOrder(accountId, newNormalEquityOrder);
        logger.info("previewNormalEquityResponse: {}", (Object)previewNormalEquityResponse);
        TradeOrderResponse placeNormalEquityResponse = apiService.placeOrder(accountId, newNormalEquityOrder);
        logger.info("placeNormalEquityResponse: {}", (Object)placeNormalEquityResponse);
        TradeClientV3Event.doSleep();
        TradeOrder replaceNormalEquityOrder = new TradeOrder();
        ArrayList<TradeOrderItem> replaceNormalEquityOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem replaceEquityOrder = new TradeOrderItem();
        replaceEquityOrder.setClientOrderId(normalEquityOrder.getClientOrderId());
        replaceEquityOrder.setQuantity("10");
        replaceEquityOrder.setLimitPrice("0.1");
        replaceNormalEquityOrders.add(replaceEquityOrder);
        replaceNormalEquityOrder.setModifyOrders(replaceNormalEquityOrders);
        TradeOrderResponse replaceNormalEquityResponse = apiService.replaceOrder(accountId, replaceNormalEquityOrder);
        logger.info("replaceNormalEquityResponse: {}", (Object)replaceNormalEquityResponse);
        TradeClientV3Event.doSleep();
        TradeOrder cancelNormalEquityOrder = new TradeOrder();
        cancelNormalEquityOrder.setClientOrderId(normalEquityOrder.getClientOrderId());
        TradeOrderResponse cancelNormalEquityResponse = apiService.cancelOrder(accountId, cancelNormalEquityOrder);
        logger.info("cancelNormalEquityResponse: {}", (Object)cancelNormalEquityResponse);
        List listOrdersResponse = apiService.listOrders(accountId, Integer.valueOf(10), null, null, null);
        logger.info("listOrdersResponse: {}", (Object)listOrdersResponse);
        List openOrdersResponse = apiService.openOrders(accountId, Integer.valueOf(10), null);
        logger.info("openOrdersResponse: {}", (Object)openOrdersResponse);
        OrderHistory orderDetailResponse = apiService.getOrderDetails(accountId, normalEquityOrder.getClientOrderId());
        logger.info("orderDetailResponse: {}", (Object)orderDetailResponse);
    }

    private static void doSleep() throws InterruptedException {
        int totalSeconds = 5;
        boolean intervalSeconds = true;
        for (int elapsed = 1; elapsed <= 5; ++elapsed) {
            Thread.sleep(1000L);
            logger.info("Waiting {} seconds before starting the next step... (elapsed {}s / {}s)", new Object[]{1, elapsed, 5});
        }
        logger.info("Wait completed, start next step...");
    }
}

